# Copyright (c) 2024-2026, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import enum
import numpy.dtypes
from _typeshed import Incomplete
from typing import Any, Callable, ClassVar

STATUS_FULL_MPG: int
STATUS_INVALID: int
STATUS_IS_BOOTSTRAPPED: int
STATUS_IS_INITIALIZED: int
STATUS_LIMITED_MPG: int
STATUS_NOT_INITIALIZED: int
TEAMS_MIN: int
TEAM_GPU_LEADERS: int
TEAM_GPU_LEADERS_INDEX: int
TEAM_INDEX_MAX: int
TEAM_INVALID: int
TEAM_NODE: int
TEAM_NODE_INDEX: int
TEAM_SAME_GPU: int
TEAM_SAME_GPU_INDEX: int
TEAM_SAME_MYPE_NODE: int
TEAM_SAME_MYPE_NODE_INDEX: int
TEAM_SHARED: int
TEAM_SHARED_INDEX: int
TEAM_WORLD: int
TEAM_WORLD_INDEX: int
__pyx_capi__: dict
__test__: dict
align: _cython_3_1_2.cython_function_or_method
barrier_all_on_stream: _cython_3_1_2.cython_function_or_method
calloc: _cython_3_1_2.cython_function_or_method
check_status: _cython_3_1_2.cython_function_or_method
free: _cython_3_1_2.cython_function_or_method
get_uniqueid: _cython_3_1_2.cython_function_or_method
hostlib_finalize: _cython_3_1_2.cython_function_or_method
hostlib_init_attr: _cython_3_1_2.cython_function_or_method
init_attr_dtype: numpy.dtypes.VoidDType
init_status: _cython_3_1_2.cython_function_or_method
int_p: _cython_3_1_2.cython_function_or_method
malloc: _cython_3_1_2.cython_function_or_method
my_pe: _cython_3_1_2.cython_function_or_method
n_pes: _cython_3_1_2.cython_function_or_method
ptr: _cython_3_1_2.cython_function_or_method
set_attr_uniqueid_args: _cython_3_1_2.cython_function_or_method
sync_all_on_stream: _cython_3_1_2.cython_function_or_method
team_my_pe: _cython_3_1_2.cython_function_or_method
uniqueid_dtype: numpy.dtypes.VoidDType

class Flags(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    INIT_MAX: ClassVar[Flags] = ...
    INIT_THREAD_PES: ClassVar[Flags] = ...
    INIT_WITH_MPI_COMM: ClassVar[Flags] = ...
    INIT_WITH_SHMEM: ClassVar[Flags] = ...
    INIT_WITH_UNIQUEID: ClassVar[Flags] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class InitAttr:
    mpi_comm: Incomplete
    ptr: Incomplete
    version: Incomplete
    def __init__(self) -> Any: ...
    def __reduce__(self): ...
    def __reduce_cython__(self) -> Any: ...
    def __setstate_cython__(self, __pyx_state) -> Any: ...

class NvshmemError(Exception):
    def __init__(self, status) -> Any: ...
    def __reduce__(self) -> Any: ...

class Status(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ERROR_COLLECTIVE_LAUNCH_FAILED: ClassVar[Status] = ...
    ERROR_GPU_NOT_SELECTED: ClassVar[Status] = ...
    ERROR_INTERNAL: ClassVar[Status] = ...
    ERROR_INVALID_VALUE: ClassVar[Status] = ...
    ERROR_NOT_SUPPORTED: ClassVar[Status] = ...
    ERROR_OUT_OF_MEMORY: ClassVar[Status] = ...
    ERROR_SENTINEL: ClassVar[Status] = ...
    ERROR_SYMMETRY: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class UniqueId(uniqueid):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __reduce__(self): ...
    def __reduce_cython__(self) -> Any: ...
    def __setstate_cython__(self, __pyx_state) -> Any: ...

class uniqueid:
    ptr: Incomplete
    version: Incomplete
    def __init__(self, size=...) -> Any: ...
    @staticmethod
    def from_data(data) -> Any: ...
    @staticmethod
    def from_ptr(intptr_tptr, size_tsize=..., boolreadonly=...) -> Any: ...
    def __delitem__(self, other) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index): ...
    def __gt__(self, other: object) -> bool: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __reduce__(self): ...
    def __reduce_cython__(self) -> Any: ...
    def __setitem__(self, index, object) -> None: ...
    def __setstate_cython__(self, __pyx_state) -> Any: ...
