/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class CreatePartitionsResponse
extends AbstractResponse {
    private final CreatePartitionsResponseData data;

    public CreatePartitionsResponse(CreatePartitionsResponseData data) {
        super(ApiKeys.CREATE_PARTITIONS);
        this.data = data;
    }

    @Override
    public CreatePartitionsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.results().forEach(result -> CreatePartitionsResponse.updateErrorCounts(counts, Errors.forCode(result.errorCode())));
        return counts;
    }

    public static CreatePartitionsResponse parse(Readable readable, short version) {
        return new CreatePartitionsResponse(new CreatePartitionsResponseData(readable, version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }
}

