/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.SegmentSortMissing;
import org.opensearch.client.opensearch.indices.SegmentSortMode;
import org.opensearch.client.opensearch.indices.SegmentSortOrder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSegmentSort
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSegmentSort> {
    @Nonnull
    private final List<String> field;
    @Nonnull
    private final List<SegmentSortMissing> missing;
    @Nonnull
    private final List<SegmentSortMode> mode;
    @Nonnull
    private final List<SegmentSortOrder> order;
    public static final JsonpDeserializer<IndexSegmentSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSegmentSort::setupIndexSegmentSortDeserializer);

    private IndexSegmentSort(Builder builder) {
        this.field = ApiTypeHelper.unmodifiable(builder.field);
        this.missing = ApiTypeHelper.unmodifiable(builder.missing);
        this.mode = ApiTypeHelper.unmodifiable(builder.mode);
        this.order = ApiTypeHelper.unmodifiable(builder.order);
    }

    public static IndexSegmentSort of(Function<Builder, ObjectBuilder<IndexSegmentSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> field() {
        return this.field;
    }

    @Nonnull
    public final List<SegmentSortMissing> missing() {
        return this.missing;
    }

    @Nonnull
    public final List<SegmentSortMode> mode() {
        return this.mode;
    }

    @Nonnull
    public final List<SegmentSortOrder> order() {
        return this.order;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.field)) {
            generator.writeKey("field");
            generator.writeStartArray();
            for (String string : this.field) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.missing)) {
            generator.writeKey("missing");
            generator.writeStartArray();
            for (SegmentSortMissing segmentSortMissing : this.missing) {
                segmentSortMissing.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.mode)) {
            generator.writeKey("mode");
            generator.writeStartArray();
            for (SegmentSortMode segmentSortMode : this.mode) {
                segmentSortMode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (SegmentSortOrder segmentSortOrder : this.order) {
                segmentSortOrder.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSegmentSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field");
        op.add(Builder::missing, JsonpDeserializer.arrayDeserializer(SegmentSortMissing._DESERIALIZER), "missing");
        op.add(Builder::mode, JsonpDeserializer.arrayDeserializer(SegmentSortMode._DESERIALIZER), "mode");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(SegmentSortOrder._DESERIALIZER), "order");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.order);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSegmentSort other = (IndexSegmentSort)o;
        return Objects.equals(this.field, other.field) && Objects.equals(this.missing, other.missing) && Objects.equals(this.mode, other.mode) && Objects.equals(this.order, other.order);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSegmentSort> {
        @Nullable
        private List<String> field;
        @Nullable
        private List<SegmentSortMissing> missing;
        @Nullable
        private List<SegmentSortMode> mode;
        @Nullable
        private List<SegmentSortOrder> order;

        public Builder() {
        }

        private Builder(IndexSegmentSort o) {
            this.field = Builder._listCopy(o.field);
            this.missing = Builder._listCopy(o.missing);
            this.mode = Builder._listCopy(o.mode);
            this.order = Builder._listCopy(o.order);
        }

        private Builder(Builder o) {
            this.field = Builder._listCopy(o.field);
            this.missing = Builder._listCopy(o.missing);
            this.mode = Builder._listCopy(o.mode);
            this.order = Builder._listCopy(o.order);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder field(List<String> list) {
            this.field = Builder._listAddAll(this.field, list);
            return this;
        }

        @Nonnull
        public final Builder field(String value, String ... values) {
            this.field = Builder._listAdd(this.field, value, values);
            return this;
        }

        @Nonnull
        public final Builder missing(List<SegmentSortMissing> list) {
            this.missing = Builder._listAddAll(this.missing, list);
            return this;
        }

        @Nonnull
        public final Builder missing(SegmentSortMissing value, SegmentSortMissing ... values) {
            this.missing = Builder._listAdd(this.missing, value, values);
            return this;
        }

        @Nonnull
        public final Builder mode(List<SegmentSortMode> list) {
            this.mode = Builder._listAddAll(this.mode, list);
            return this;
        }

        @Nonnull
        public final Builder mode(SegmentSortMode value, SegmentSortMode ... values) {
            this.mode = Builder._listAdd(this.mode, value, values);
            return this;
        }

        @Nonnull
        public final Builder order(List<SegmentSortOrder> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        @Nonnull
        public final Builder order(SegmentSortOrder value, SegmentSortOrder ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        @Override
        @Nonnull
        public IndexSegmentSort build() {
            this._checkSingleUse();
            return new IndexSegmentSort(this);
        }
    }
}

