/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.DefaultRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.Request;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpMethodName;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.SdkInternalList;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.CloudWatchDestination;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.CloudWatchDimensionConfiguration;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.EventDestination;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.KinesisFirehoseDestination;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.SNSDestination;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.UpdateConfigurationSetEventDestinationRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Marshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class UpdateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<UpdateConfigurationSetEventDestinationRequest>, UpdateConfigurationSetEventDestinationRequest> {
    @Override
    public Request<UpdateConfigurationSetEventDestinationRequest> marshall(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (updateConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateConfigurationSetEventDestinationRequest> request = new DefaultRequest<UpdateConfigurationSetEventDestinationRequest>(updateConfigurationSetEventDestinationRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "UpdateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationSetEventDestinationRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(updateConfigurationSetEventDestinationRequest.getConfigurationSetName()));
        }
        if ((eventDestination = updateConfigurationSetEventDestinationRequest.getEventDestination()) != null) {
            SNSDestination sNSDestination;
            CloudWatchDestination cloudWatchDestination;
            KinesisFirehoseDestination kinesisFirehoseDestination;
            if (eventDestination.getName() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString(eventDestination.getName()));
            }
            if (eventDestination.getEnabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean(eventDestination.getEnabled()));
            }
            if (!eventDestination.getMatchingEventTypes().isEmpty() || !((SdkInternalList)eventDestination.getMatchingEventTypes()).isAutoConstruct()) {
                SdkInternalList matchingEventTypesList = (SdkInternalList)eventDestination.getMatchingEventTypes();
                int matchingEventTypesListIndex = 1;
                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringUtils.fromString(matchingEventTypesListValue));
                    }
                    ++matchingEventTypesListIndex;
                }
            }
            if ((kinesisFirehoseDestination = eventDestination.getKinesisFirehoseDestination()) != null) {
                if (kinesisFirehoseDestination.getIAMRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringUtils.fromString(kinesisFirehoseDestination.getIAMRoleARN()));
                }
                if (kinesisFirehoseDestination.getDeliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringUtils.fromString(kinesisFirehoseDestination.getDeliveryStreamARN()));
                }
            }
            if (!((cloudWatchDestination = eventDestination.getCloudWatchDestination()) == null || cloudWatchDestination.getDimensionConfigurations().isEmpty() && ((SdkInternalList)cloudWatchDestination.getDimensionConfigurations()).isAutoConstruct())) {
                SdkInternalList dimensionConfigurationsList = (SdkInternalList)cloudWatchDestination.getDimensionConfigurations();
                int dimensionConfigurationsListIndex = 1;
                for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                    if (dimensionConfigurationsListValue != null) {
                        if (dimensionConfigurationsListValue.getDimensionName() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringUtils.fromString(dimensionConfigurationsListValue.getDimensionName()));
                        }
                        if (dimensionConfigurationsListValue.getDimensionValueSource() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringUtils.fromString(dimensionConfigurationsListValue.getDimensionValueSource()));
                        }
                        if (dimensionConfigurationsListValue.getDefaultDimensionValue() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringUtils.fromString(dimensionConfigurationsListValue.getDefaultDimensionValue()));
                        }
                    }
                    ++dimensionConfigurationsListIndex;
                }
            }
            if ((sNSDestination = eventDestination.getSNSDestination()) != null && sNSDestination.getTopicARN() != null) {
                request.addParameter("EventDestination.SNSDestination.TopicARN", StringUtils.fromString(sNSDestination.getTopicARN()));
            }
        }
        return request;
    }
}

