/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.joda.time.Instant;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.ForecastResultRequest;
import org.opensearch.forecast.transport.ForecastRunOnceAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestRunOnceForecasterAction
extends BaseRestHandler {
    public static final String FORECASTER_ACTION = "run_forecaster_once";

    public String getName() {
        return FORECASTER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_forecast/forecasters", "forecasterID", "_run_once")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterId = request.param("forecasterID");
            ForecastResultRequest getRequest = new ForecastResultRequest(forecasterId, -1L, Instant.now().getMillis());
            return channel -> client.execute((ActionType)ForecastRunOnceAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }
}

