/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.hll.AuxHashMap;
import com.yahoo.sketches.hll.DirectAuxHashMap;
import com.yahoo.sketches.hll.DirectHllArray;
import com.yahoo.sketches.hll.HeapAuxHashMap;
import com.yahoo.sketches.hll.Hll4Array;
import com.yahoo.sketches.hll.Hll4Update;
import com.yahoo.sketches.hll.HllPairIterator;
import com.yahoo.sketches.hll.HllSketch;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class DirectHll4Array
extends DirectHllArray {
    DirectHll4Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_4, wmem);
        if (PreambleUtil.extractAuxCount(this.mem) > 0) {
            this.putAuxHashMap(new DirectAuxHashMap(this, false), false);
        }
    }

    DirectHll4Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_4, mem);
        int auxCount = PreambleUtil.extractAuxCount(mem);
        if (auxCount > 0) {
            boolean compact = PreambleUtil.extractCompactFlag(mem);
            AuxHashMap auxHashMap = compact ? HeapAuxHashMap.heapify(mem, this.auxStart, lgConfigK, auxCount, compact) : new DirectAuxHashMap(this, false);
            this.putAuxHashMap(auxHashMap, compact);
        }
    }

    @Override
    HllSketchImpl copy() {
        return Hll4Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int newValue;
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        if ((newValue = HllUtil.getValue(coupon)) <= this.getCurMin()) {
            return this;
        }
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getLow26(coupon) & configKmask;
        Hll4Update.internalHll4Update(this, slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll4Array.hll4ArrBytes(this.lgConfigK);
    }

    @Override
    PairIterator iterator() {
        return new DirectHll4Iterator(1 << this.lgConfigK);
    }

    @Override
    final int getSlot(int slotNo) {
        long offset = PreambleUtil.HLL_BYTE_ARR_START + (slotNo >>> 1);
        int theByte = this.mem.getByte(offset);
        if ((slotNo & 1) > 0) {
            theByte >>>= 4;
        }
        return theByte & 0xF;
    }

    @Override
    int getUpdatableSerializationBytes() {
        AuxHashMap auxHashMap = this.getAuxHashMap();
        int auxBytes = auxHashMap == null ? 4 << HllUtil.LG_AUX_ARR_INTS[this.lgConfigK] : 4 << auxHashMap.getLgAuxArrInts();
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes() + auxBytes;
    }

    @Override
    final void putSlot(int slotNo, int newValue) {
        long offset = PreambleUtil.HLL_BYTE_ARR_START + (slotNo >>> 1);
        byte oldValue = this.mem.getByte(offset);
        byte value = (slotNo & 1) == 0 ? (byte)(oldValue & 0xF0 | newValue & 0xF) : (byte)(oldValue & 0xF | newValue << 4 & 0xF0);
        this.wmem.putByte(offset, value);
    }

    @Override
    byte[] toCompactByteArray() {
        boolean srcMemIsCompact = PreambleUtil.extractCompactFlag(this.mem);
        int totBytes = this.getCompactSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        WritableMemory memOut = WritableMemory.wrap((byte[])byteArr);
        if (srcMemIsCompact) {
            this.mem.copyTo(0L, memOut, 0L, (long)totBytes);
            return byteArr;
        }
        this.mem.copyTo(0L, memOut, 0L, (long)this.auxStart);
        if (this.auxHashMap != null) {
            int auxCount = this.auxHashMap.getAuxCount();
            PreambleUtil.insertAuxCount(memOut, auxCount);
            PreambleUtil.insertLgArr(memOut, this.auxHashMap.getLgAuxArrInts());
            PairIterator itr = this.auxHashMap.getIterator();
            int cnt = 0;
            while (itr.nextValid()) {
                PreambleUtil.insertInt(memOut, this.auxStart + (cnt++ << 2), itr.getPair());
            }
            assert (cnt == auxCount);
        }
        PreambleUtil.insertCompactFlag(memOut, true);
        return byteArr;
    }

    @Override
    byte[] toUpdatableByteArray() {
        boolean memIsCompact = PreambleUtil.extractCompactFlag(this.mem);
        int totBytes = this.getUpdatableSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        WritableMemory memOut = WritableMemory.wrap((byte[])byteArr);
        if (!memIsCompact) {
            this.mem.copyTo(0L, memOut, 0L, (long)totBytes);
            return byteArr;
        }
        HllSketch heapSk = HllSketch.heapify(this.mem);
        return heapSk.toUpdatableByteArray();
    }

    final class DirectHll4Iterator
    extends HllPairIterator {
        DirectHll4Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            int nib = DirectHll4Array.this.getSlot(this.index);
            if (nib == 15) {
                AuxHashMap auxHashMap = DirectHll4Array.this.getAuxHashMap();
                return auxHashMap.mustFindValueFor(this.index);
            }
            return nib + DirectHll4Array.this.getCurMin();
        }
    }
}

