/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PaddingPacket;
import org.bouncycastle.crypto.CryptoServicesRegistrar;

public class PGPPadding {
    private PaddingPacket p;
    public static final int MIN_PADDING_LEN = 16;
    public static final int MAX_PADDING_LEN = 255;

    public PGPPadding(BCPGInputStream in) throws IOException {
        Packet packet = in.readPacket();
        if (!(packet instanceof PaddingPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.p = (PaddingPacket)packet;
    }

    public PGPPadding() {
        this(CryptoServicesRegistrar.getSecureRandom());
    }

    public PGPPadding(SecureRandom random) {
        this(16 + random.nextInt(240), random);
    }

    public PGPPadding(int len) {
        this(len, CryptoServicesRegistrar.getSecureRandom());
    }

    public PGPPadding(int len, SecureRandom random) {
        this.p = new PaddingPacket(len, random);
    }

    public byte[] getPadding() {
        return this.p.getPadding();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream pOut = BCPGOutputStream.wrap(outStream);
        this.p.encode(pOut);
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat format) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, format);
        this.encode(pOut);
        pOut.close();
        return bOut.toByteArray();
    }
}

