/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_falcon_v4_h__
#define __lr10_dev_falcon_v4_h__
/* This file is autogenerated.  Do not edit */
#define NV_PFALCON_FALCON_INTR_RETRIGGER(i)                                                            (0x000003e8+(i)*4) /* -W-4A */
#define NV_PFALCON_FALCON_INTR_RETRIGGER__SIZE_1                                                       2              /*       */
#define NV_PFALCON_FALCON_INTR_RETRIGGER_TRIGGER                                                       0:0            /* -W-VF */
#define NV_PFALCON_FALCON_INTR_RETRIGGER_TRIGGER_TRUE                                                  0x00000001     /* -W--V */

#define NV_PFALCON_FALCON_HWCFG1                                                                       0x0000012c     /* R--4R */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV                                                              3:0            /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_INIT                                                         0x00000006     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_1_0                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_2_0                                                          0x00000002     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_3_0                                                          0x00000003     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_4_0                                                          0x00000004     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_5_0                                                          0x00000005     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_6_0                                                          0x00000006     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_7_0                                                          0x00000007     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_SECURITY_MODEL                                                        5:4            /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_SECURITY_MODEL_INIT                                                   0x00000003     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_SECURITY_MODEL_NONE                                                   0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_SECURITY_MODEL_LIGHT                                                  0x00000002     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_SECURITY_MODEL_HEAVY                                                  0x00000003     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION                                                   7:6            /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION_INIT                                              0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION_0                                                 0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION_1                                                 0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION_2                                                 0x00000002     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CORE_REV_SUBVERSION_3                                                 0x00000003     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_PORTS                                                            11:8           /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_PORTS_INIT                                                       0x00000001     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_PORTS                                                            15:12          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_PORTS_INIT                                                       0x00000001     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_TAG_WIDTH                                                             20:16          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_TAG_WIDTH_INIT                                                        0x00000010     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_TAG_WIDTH                                                        25:21          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_TAG_WIDTH_INIT                                                   0x00000010     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_DBG_PRIV_BUS                                                          27:27          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_DBG_PRIV_BUS_INIT                                                     0x00000001     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_DBG_PRIV_BUS_ENABLE                                                   0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_DBG_PRIV_BUS_DISABLE                                                  0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CSB_SIZE_16M                                                          28:28          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_CSB_SIZE_16M_INIT                                                     0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_CSB_SIZE_16M_TRUE                                                     0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_CSB_SIZE_16M_FALSE                                                    0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_PRIV_DIRECT                                                           29:29          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_PRIV_DIRECT_INIT                                                      0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_PRIV_DIRECT_TRUE                                                      0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_PRIV_DIRECT_FALSE                                                     0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_APERTURES                                                        30:30          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_APERTURES_INIT                                                   0x00000001     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_APERTURES_ENABLE                                                 0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_DMEM_APERTURES_DISABLE                                                0x00000000     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_AUTOFILL                                                         31:31          /* R-IVF */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_AUTOFILL_INIT                                                    0x00000001     /* R-I-V */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_AUTOFILL_ENABLE                                                  0x00000001     /* R---V */
#define NV_PFALCON_FALCON_HWCFG1_IMEM_AUTOFILL_DISABLE                                                 0x00000000     /* R---V */

#define NV_PFALCON_FALCON_IRQSSET                                                                      0x00000000     /* -W-4R */
#define NV_PFALCON_FALCON_IRQSSET_GPTMR                                                                0:0            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_GPTMR_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_WDTMR                                                                1:1            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_WDTMR_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_MTHD                                                                 2:2            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_MTHD_SET                                                             0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_CTXSW                                                                3:3            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_CTXSW_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_HALT                                                                 4:4            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_HALT_SET                                                             0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_EXTERR                                                               5:5            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_EXTERR_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_SWGEN0                                                               6:6            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_SWGEN0_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_SWGEN1                                                               7:7            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_SWGEN1_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_EXT                                                                  15:8           /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_DMA                                                                  16:16          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_DMA_SET                                                              0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_SHA                                                                  17:17          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_SHA_SET                                                              0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_MEMERR                                                               18:18          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_MEMERR_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_FALCON                                                               19:19          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_FALCON_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_RISCV                                                                20:20          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_RISCV_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSSET_TRACE                                                                21:21          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSSET_TRACE_SET                                                            0x00000001     /* -W--V */

#define NV_PFALCON_FALCON_TRACEPC                                                                      0x0000014c     /* R--4R */
#define NV_PFALCON_FALCON_TRACEPC_PC                                                                   23:0           /* R--VF */

#define NV_PFALCON_FALCON_TRACEIDX                                                                     0x00000148     /* RW-4R */
#define NV_PFALCON_FALCON_TRACEIDX_CNT                                                                 31:24          /* R-IVF */
#define NV_PFALCON_FALCON_TRACEIDX_CNT_INIT                                                            0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_TRACEIDX_MAXIDX                                                              23:16          /* R--VF */
#define NV_PFALCON_FALCON_TRACEIDX_IDX                                                                 7:0            /* RWIVF */
#define NV_PFALCON_FALCON_TRACEIDX_IDX_INIT                                                            0x00000000     /* RWI-V */

#define NV_PFALCON_FALCON_MAILBOX0                                                                     0x00000040     /* RW-4R */
#define NV_PFALCON_FALCON_MAILBOX0_DATA                                                                31:0           /* RWIVF */
#define NV_PFALCON_FALCON_MAILBOX0_DATA_INIT                                                           0x00000000     /* RWI-V */

#define NV_PFALCON_FALCON_IRQSCLR                                                                      0x00000004     /* -W-4R */
#define NV_PFALCON_FALCON_IRQSCLR_GPTMR                                                                0:0            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_GPTMR_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_WDTMR                                                                1:1            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_WDTMR_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_MTHD                                                                 2:2            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_MTHD_SET                                                             0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_CTXSW                                                                3:3            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_CTXSW_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_HALT                                                                 4:4            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_HALT_SET                                                             0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_EXTERR                                                               5:5            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_EXTERR_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_SWGEN0                                                               6:6            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_SWGEN0_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_SWGEN1                                                               7:7            /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_SWGEN1_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_EXT                                                                  15:8           /*       */
#define NV_PFALCON_FALCON_IRQSCLR_DMA                                                                  16:16          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_DMA_SET                                                              0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_SHA                                                                  17:17          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_SHA_SET                                                              0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_MEMERR                                                               18:18          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_MEMERR_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_FALCON                                                               19:19          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_FALCON_SET                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_RISCV                                                                20:20          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_RISCV_SET                                                            0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_IRQSCLR_TRACE                                                                21:21          /* -WXVF */
#define NV_PFALCON_FALCON_IRQSCLR_TRACE_SET                                                            0x00000001     /* -W--V */

#define NV_PFALCON_FALCON_IMEMT(i)                                                                     (0x00000188+(i)*16) /* RW-4A */
#define NV_PFALCON_FALCON_IMEMT__SIZE_1                                                                4              /*       */
#define NV_PFALCON_FALCON_IMEMT_TAG                                                                    15:0           /* RW-VF */

#define NV_PFALCON_FALCON_IMEMD(i)                                                                     (0x00000184+(i)*16) /* RW-4A */
#define NV_PFALCON_FALCON_IMEMD__SIZE_1                                                                4              /*       */
#define NV_PFALCON_FALCON_IMEMD_DATA                                                                   31:0           /* RW-VF */

#define NV_PFALCON_FALCON_IMEMC(i)                                                                     (0x00000180+(i)*16) /* RW-4A */
#define NV_PFALCON_FALCON_IMEMC__SIZE_1                                                                4              /*       */
#define NV_PFALCON_FALCON_IMEMC_OFFS                                                                   7:2            /* RWIVF */
#define NV_PFALCON_FALCON_IMEMC_OFFS_INIT                                                              0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IMEMC_BLK                                                                    23:8           /* RWIVF */
#define NV_PFALCON_FALCON_IMEMC_BLK_INIT                                                               0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IMEMC_AINCW                                                                  24:24          /* RWIVF */
#define NV_PFALCON_FALCON_IMEMC_AINCW_INIT                                                             0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IMEMC_AINCW_TRUE                                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IMEMC_AINCW_FALSE                                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IMEMC_AINCR                                                                  25:25          /* RWIVF */
#define NV_PFALCON_FALCON_IMEMC_AINCR_INIT                                                             0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IMEMC_AINCR_TRUE                                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IMEMC_AINCR_FALSE                                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IMEMC_SECURE                                                                 28:28          /* RWIVF */
#define NV_PFALCON_FALCON_IMEMC_SECURE_INIT                                                            0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IMEMC_SEC_ATOMIC                                                             29:29          /* R-IVF */
#define NV_PFALCON_FALCON_IMEMC_SEC_ATOMIC_TRUE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IMEMC_SEC_ATOMIC_FALSE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IMEMC_SEC_WR_VIO                                                             30:30          /* R-IVF */
#define NV_PFALCON_FALCON_IMEMC_SEC_WR_VIO_TRUE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IMEMC_SEC_WR_VIO_FALSE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IMEMC_SEC_LOCK                                                               31:31          /* R-IVF */
#define NV_PFALCON_FALCON_IMEMC_SEC_LOCK_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IMEMC_SEC_LOCK_FALSE                                                         0x00000000     /* R-I-V */

#define NV_PFALCON_FALCON_DMEMC(i)                                                                     (0x000001c0+(i)*8) /* RW-4A */
#define NV_PFALCON_FALCON_DMEMC__SIZE_1                                                                8              /*       */
#define NV_PFALCON_FALCON_DMEMC_ADDRESS                                                                23:0           /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_ADDRESS_INIT                                                           0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_OFFS                                                                   7:2            /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_OFFS_INIT                                                              0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_BLK                                                                    23:8           /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_BLK_INIT                                                               0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_AINCW                                                                  24:24          /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_AINCW_INIT                                                             0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_AINCW_TRUE                                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_AINCW_FALSE                                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_AINCR                                                                  25:25          /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_AINCR_INIT                                                             0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_AINCR_TRUE                                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_AINCR_FALSE                                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_SETTAG                                                                 26:26          /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_SETTAG_INIT                                                            0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_SETTAG_TRUE                                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_SETTAG_FALSE                                                           0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_SETLVL                                                                 27:27          /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_SETLVL_INIT                                                            0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_SETLVL_TRUE                                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_SETLVL_FALSE                                                           0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_VA                                                                     28:28          /* RWIVF */
#define NV_PFALCON_FALCON_DMEMC_VA_INIT                                                                0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_DMEMC_VA_TRUE                                                                0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_VA_FALSE                                                               0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMEMC_MISS                                                                   29:29          /* R-IVF */
#define NV_PFALCON_FALCON_DMEMC_MISS_TRUE                                                              0x00000001     /* R---V */
#define NV_PFALCON_FALCON_DMEMC_MISS_FALSE                                                             0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_DMEMC_MULTIHIT                                                               30:30          /* R-IVF */
#define NV_PFALCON_FALCON_DMEMC_MULTIHIT_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_DMEMC_MULTIHIT_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_DMEMC_LVLERR                                                                 31:31          /* R-IVF */
#define NV_PFALCON_FALCON_DMEMC_LVLERR_TRUE                                                            0x00000001     /* R---V */
#define NV_PFALCON_FALCON_DMEMC_LVLERR_FALSE                                                           0x00000000     /* R-I-V */

#define NV_PFALCON_FALCON_DMEMD(i)                                                                     (0x000001c4+(i)*8) /* RW-4A */
#define NV_PFALCON_FALCON_DMEMD__SIZE_1                                                                8              /*       */
#define NV_PFALCON_FALCON_DMEMD_DATA                                                                   31:0           /* RW-VF */

#define NV_PFALCON_FALCON_DMACTL                                                                       0x0000010c     /* RW-4R */
#define NV_PFALCON_FALCON_DMACTL_REQUIRE_CTX                                                           0:0            /* RWIVF */
#define NV_PFALCON_FALCON_DMACTL_REQUIRE_CTX_INIT                                                      0x00000001     /* RWI-V */
#define NV_PFALCON_FALCON_DMACTL_REQUIRE_CTX_TRUE                                                      0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_DMACTL_REQUIRE_CTX_FALSE                                                     0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_DMACTL_DMEM_SCRUBBING                                                        1:1            /* R--VF */
#define NV_PFALCON_FALCON_DMACTL_DMEM_SCRUBBING_PENDING                                                0x00000001     /* R---V */
#define NV_PFALCON_FALCON_DMACTL_DMEM_SCRUBBING_DONE                                                   0x00000000     /* R---V */
#define NV_PFALCON_FALCON_DMACTL_IMEM_SCRUBBING                                                        2:2            /* R--VF */
#define NV_PFALCON_FALCON_DMACTL_IMEM_SCRUBBING_PENDING                                                0x00000001     /* R---V */
#define NV_PFALCON_FALCON_DMACTL_IMEM_SCRUBBING_DONE                                                   0x00000000     /* R---V */
#define NV_PFALCON_FALCON_DMACTL_DMAQ_NUM                                                              6:3            /* R--VF */
#define NV_PFALCON_FALCON_DMACTL_SECURE_STAT                                                           7:7            /* R--VF */

#define NV_PFALCON_FALCON_BOOTVEC                                                                      0x00000104     /* RW-4R */
#define NV_PFALCON_FALCON_BOOTVEC_VEC                                                                  31:0           /* RWIVF */
#define NV_PFALCON_FALCON_BOOTVEC_VEC_INIT                                                             0x00000000     /* RWI-V */

#define NV_PFALCON_FALCON_CPUCTL                                                                       0x00000100     /* RW-4R */
#define NV_PFALCON_FALCON_CPUCTL_IINVAL                                                                0:0            /* -WXVF */
#define NV_PFALCON_FALCON_CPUCTL_IINVAL_TRUE                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_IINVAL_FALSE                                                          0x00000000     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_STARTCPU                                                              1:1            /* -WXVF */
#define NV_PFALCON_FALCON_CPUCTL_STARTCPU_TRUE                                                         0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_STARTCPU_FALSE                                                        0x00000000     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_SRESET                                                                2:2            /* -WXVF */
#define NV_PFALCON_FALCON_CPUCTL_SRESET_TRUE                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_SRESET_FALSE                                                          0x00000000     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_HRESET                                                                3:3            /* -WXVF */
#define NV_PFALCON_FALCON_CPUCTL_HRESET_TRUE                                                           0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_HRESET_FALSE                                                          0x00000000     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_HALTED                                                                4:4            /* R-XVF */
#define NV_PFALCON_FALCON_CPUCTL_HALTED_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_CPUCTL_HALTED_FALSE                                                          0x00000000     /* R---V */
#define NV_PFALCON_FALCON_CPUCTL_STOPPED                                                               5:5            /* R-XVF */
#define NV_PFALCON_FALCON_CPUCTL_STOPPED_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_CPUCTL_STOPPED_FALSE                                                         0x00000000     /* R---V */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_EN                                                              6:6            /* RWIVF */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_EN_TRUE                                                         0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_EN_FALSE                                                        0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_EN_INIT                                                         0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS                                                                 0x00000130     /* -W-4R */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_STARTCPU                                                        1:1            /* -WXVF */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_STARTCPU_TRUE                                                   0x00000001     /* -W--V */
#define NV_PFALCON_FALCON_CPUCTL_ALIAS_STARTCPU_FALSE                                                  0x00000000     /* -W--V */

#define NV_PFALCON_FALCON_MAILBOX1                                                                     0x00000044     /* RW-4R */
#define NV_PFALCON_FALCON_MAILBOX1_DATA                                                                31:0           /* RWIVF */
#define NV_PFALCON_FALCON_MAILBOX1_DATA_INIT                                                           0x00000000     /* RWI-V */

#define NV_PFALCON_FALCON_IRQSTAT                                                                      0x00000008     /* R--4R */
#define NV_PFALCON_FALCON_IRQSTAT_GPTMR                                                                0:0            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_GPTMR_FALSE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_GPTMR_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_WDTMR                                                                1:1            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_WDTMR_FALSE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_WDTMR_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_MTHD                                                                 2:2            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_MTHD_FALSE                                                           0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_MTHD_TRUE                                                            0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_CTXSW                                                                3:3            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_CTXSW_FALSE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_CTXSW_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_HALT                                                                 4:4            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_HALT_FALSE                                                           0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_HALT_TRUE                                                            0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_EXTERR                                                               5:5            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_EXTERR_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_EXTERR_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN0                                                               6:6            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN0_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN0_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN1                                                               7:7            /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN1_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_SWGEN1_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_EXT                                                                  15:8           /*       */
#define NV_PFALCON_FALCON_IRQSTAT_DMA                                                                  16:16          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_DMA_TRUE                                                             0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_DMA_FALSE                                                            0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_SHA                                                                  17:17          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_SHA_TRUE                                                             0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_SHA_FALSE                                                            0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_MEMERR                                                               18:18          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_MEMERR_TRUE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_MEMERR_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_FALCON                                                               19:19          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_FALCON_TURE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_FALCON_FALSE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_RISCV                                                                20:20          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_RISCV_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_RISCV_FALSE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQSTAT_TRACE                                                                21:21          /* R-IVF */
#define NV_PFALCON_FALCON_IRQSTAT_TRACE_TRUE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQSTAT_TRACE_FALSE                                                          0x00000000     /* R-I-V */

#define NV_PFALCON_FALCON_IRQMASK                                                                      0x00000018     /* R--4R */
#define NV_PFALCON_FALCON_IRQMASK_GPTMR                                                                0:0            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_GPTMR_DISABLE                                                        0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_GPTMR_ENABLE                                                         0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_WDTMR                                                                1:1            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_WDTMR_DISABLE                                                        0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_WDTMR_ENABLE                                                         0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_MTHD                                                                 2:2            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_MTHD_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_MTHD_ENABLE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_CTXSW                                                                3:3            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_CTXSW_DISABLE                                                        0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_CTXSW_ENABLE                                                         0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_HALT                                                                 4:4            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_HALT_DISABLE                                                         0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_HALT_ENABLE                                                          0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_EXTERR                                                               5:5            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_EXTERR_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_EXTERR_ENABLE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN0                                                               6:6            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN0_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN0_ENABLE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN1                                                               7:7            /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN1_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_SWGEN1_ENABLE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_EXT                                                                  15:8           /*       */
#define NV_PFALCON_FALCON_IRQMASK_DMA                                                                  16:16          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_DMA_ENABLE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_DMA_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_SHA                                                                  17:17          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_SHA_ENABLE                                                           0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_SHA_DISABLE                                                          0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_MEMERR                                                               18:18          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_MEMERR_ENABLE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_MEMERR_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_FALCON                                                               19:19          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_FALCON_ENABLE                                                        0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_FALCON_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_RISCV                                                                20:20          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_RISCV_ENABLE                                                         0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_RISCV_DISABLE                                                        0x00000000     /* R-I-V */
#define NV_PFALCON_FALCON_IRQMASK_TRACE                                                                21:21          /* R-IVF */
#define NV_PFALCON_FALCON_IRQMASK_TRACE_ENABLE                                                         0x00000001     /* R---V */
#define NV_PFALCON_FALCON_IRQMASK_TRACE_DISABLE                                                        0x00000000     /* R-I-V */

#define NV_PFALCON_FALCON_IRQDEST                                                                      0x0000001c     /* RW-4R */
#define NV_PFALCON_FALCON_IRQDEST_HOST_GPTMR                                                           0:0            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_GPTMR_INIT                                                      0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_GPTMR_FALCON                                                    0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_GPTMR_HOST                                                      0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_WDTMR                                                           1:1            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_WDTMR_INIT                                                      0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_WDTMR_FALCON                                                    0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_WDTMR_HOST                                                      0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_MTHD                                                            2:2            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_MTHD_INIT                                                       0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_MTHD_FALCON                                                     0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_MTHD_HOST                                                       0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_CTXSW                                                           3:3            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_CTXSW_INIT                                                      0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_CTXSW_FALCON                                                    0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_CTXSW_HOST                                                      0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_HALT                                                            4:4            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_HALT_INIT                                                       0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_HALT_FALCON                                                     0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_HALT_HOST                                                       0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_EXTERR                                                          5:5            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_EXTERR_INIT                                                     0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_EXTERR_FALCON                                                   0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_EXTERR_HOST                                                     0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN0                                                          6:6            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN0_INIT                                                     0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN0_FALCON                                                   0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN0_HOST                                                     0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN1                                                          7:7            /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN1_INIT                                                     0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN1_FALCON                                                   0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_SWGEN1_HOST                                                     0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_HOST_EXT                                                             15:8           /*       */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR                                                         16:16          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR_INIT                                                    0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ0                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ1                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR_HOST_NORMAL                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_GPTMR_HOST_NONSTALL                                           0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR                                                         17:17          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR_INIT                                                    0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ0                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ1                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR_HOST_NORMAL                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_WDTMR_HOST_NONSTALL                                           0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD                                                          18:18          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD_INIT                                                     0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ0                                              0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ1                                              0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD_HOST_NORMAL                                              0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_MTHD_HOST_NONSTALL                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW                                                         19:19          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW_INIT                                                    0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ0                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ1                                             0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW_HOST_NORMAL                                             0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_CTXSW_HOST_NONSTALL                                           0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT                                                          20:20          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT_INIT                                                     0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ0                                              0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ1                                              0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT_HOST_NORMAL                                              0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_HALT_HOST_NONSTALL                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR                                                        21:21          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR_INIT                                                   0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXTERR_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0                                                        22:22          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0_INIT                                                   0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1                                                        23:23          /* RWIVF */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1_INIT                                                   0x00000000     /* RWI-V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_PFALCON_FALCON_IRQDEST_TARGET_EXT                                                           31:24          /*       */

#define NV_PFALCON_FALCON_OS                                                                           0x00000080     /* RW-4R */
#define NV_PFALCON_FALCON_OS_VERSION                                                                   31:0           /* RWIVF */
#define NV_PFALCON_FALCON_OS_VERSION_INIT                                                              0x00000000     /* RWI-V */
#endif // __lr10_dev_falcon_v4_h__
