 module Msf::Exploit::Remote::HTTP::Pretalx::Error
    
   class ClientError < ::StandardError
     def initialize(message: nil)
       super(message || 'Pretalx Client Error')
     end
   end
    
   class DebugError < ClientError
     def initialize(message = 'Could not check if Pretalx runs in debug mode')
       super(message: message)
     end
   end

   class VersionCheckError < ClientError
    def initialize(message = 'Could not fetch version number, might not have correct permissions')
      super(message: message)
    end
   end
   
   class UnexpectedResponseError < ClientError
    def initialize(message = 'Pretalx send unexpected response')
      super(message: message)
    end
   end
   
   class SessionCookieError
    def initialize(message = 'Could not get session cookie')
      super(message: message)
    end
   end

   # Csrf token error
    class CsrfError < ClientError
      def initialize(message = 'Could not successfully extract CSRF token')
        super(message: message)
      end
    end


 end
