/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class AbstractClaimToRoleMapper
extends AbstractClaimMapper {
    private static final Logger LOG = Logger.getLogger(AbstractClaimToRoleMapper.class);

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.getRole(realm, mapperModel);
        if (role == null) {
            return;
        }
        if (this.applies(mapperModel, context)) {
            user.grantRole(role);
        }
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.getRole(realm, mapperModel);
        if (role == null) {
            return;
        }
        if (!this.applies(mapperModel, context)) {
            user.deleteRoleMapping(role);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.getRole(realm, mapperModel);
        if (role == null) {
            return;
        }
        String roleName = (String)mapperModel.getConfig().get("role");
        if (!context.hasMapperGrantedRole(roleName)) {
            if (this.applies(mapperModel, context)) {
                context.addMapperGrantedRole(roleName);
                user.grantRole(role);
            } else {
                user.deleteRoleMapping(role);
            }
        }
    }

    protected abstract boolean applies(IdentityProviderMapperModel var1, BrokeredIdentityContext var2);

    private RoleModel getRole(RealmModel realm, IdentityProviderMapperModel mapperModel) {
        String roleName = (String)mapperModel.getConfig().get("role");
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            LOG.warnf("Unable to find role '%s' referenced by mapper '%s' on realm '%s'.", (Object)roleName, (Object)mapperModel.getName(), (Object)realm.getName());
        }
        return role;
    }
}

