/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ThemeManager;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.DefaultThemeManagerFactory;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeResourceProvider;
import org.keycloak.theme.ThemeSelectorProvider;

public class DefaultThemeManager
implements ThemeManager {
    private static final Logger log = Logger.getLogger(DefaultThemeManager.class);
    private final DefaultThemeManagerFactory factory;
    private final KeycloakSession session;
    private List<ThemeProvider> providers;

    public DefaultThemeManager(DefaultThemeManagerFactory factory, KeycloakSession session) {
        this.factory = factory;
        this.session = session;
    }

    public Theme getTheme(Theme.Type type) {
        String name = ((ThemeSelectorProvider)this.session.getProvider(ThemeSelectorProvider.class)).getThemeName(type);
        return this.getTheme(name, type);
    }

    public Theme getTheme(String name, Theme.Type type) {
        Theme theme = this.factory.getCachedTheme(name, type);
        if (theme == null) {
            theme = this.loadTheme(name, type);
            if (theme == null) {
                String defaultThemeName = ((ThemeSelectorProvider)this.session.getProvider(ThemeSelectorProvider.class)).getDefaultThemeName(type);
                theme = this.loadTheme(defaultThemeName, type);
                log.errorv("Failed to find {0} theme {1}, using built-in themes", (Object)type, (Object)name);
            } else {
                theme = this.factory.addCachedTheme(name, type, theme);
            }
        }
        return theme;
    }

    public Set<String> nameSet(Theme.Type type) {
        HashSet<String> themes = new HashSet<String>();
        for (ThemeProvider p : this.getProviders()) {
            themes.addAll(p.nameSet(type));
        }
        return themes;
    }

    public boolean isCacheEnabled() {
        return this.factory.isCacheEnabled();
    }

    public void clearCache() {
        this.factory.clearCache();
    }

    public void close() {
    }

    private Theme loadTheme(String name, Theme.Type type) {
        Theme theme = this.findTheme(name, type);
        if (theme == null) {
            return null;
        }
        LinkedList<Theme> themes = new LinkedList<Theme>();
        themes.add(theme);
        if (!this.processImportedTheme(themes, theme, name, type)) {
            return null;
        }
        if (theme.getParentName() != null) {
            String parentName = theme.getParentName();
            while (parentName != null) {
                String currentThemeName = theme.getName();
                theme = this.findTheme(parentName, type);
                if (theme == null) {
                    log.warnf("Not found parent theme '%s' of theme '%s'. Unable to load %s theme '%s' due to this.", new Object[]{parentName, currentThemeName, type, name});
                    return null;
                }
                themes.add(theme);
                if (!this.processImportedTheme(themes, theme, name, type)) {
                    return null;
                }
                parentName = theme.getParentName();
            }
        }
        return new ExtendingTheme(themes, this.session.getAllProviders(ThemeResourceProvider.class));
    }

    private Theme findTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            try {
                return p.getTheme(name, type);
            }
            catch (IOException e) {
                log.errorv((Throwable)e, String.valueOf(p.getClass()) + " failed to load theme, type={0}, name={1}", (Object)type, (Object)name);
            }
        }
        return null;
    }

    private boolean processImportedTheme(List<Theme> themes, Theme theme, String origThemeName, Theme.Type type) {
        if (theme.getImportName() != null) {
            String[] s = theme.getImportName().split("/");
            Theme importedTheme = this.findTheme(s[1], Theme.Type.valueOf((String)s[0].toUpperCase()));
            if (importedTheme == null) {
                log.warnf("Not found theme '%s' referenced as import of theme '%s'. Unable to load %s theme '%s' due to this.", new Object[]{theme.getImportName(), theme.getName(), type, origThemeName});
                return false;
            }
            themes.add(importedTheme);
        }
        return true;
    }

    private static Locale getParent(Locale locale) {
        return LocaleUtil.getParentLocale(locale);
    }

    private List<ThemeProvider> getProviders() {
        if (this.providers == null) {
            this.providers = new LinkedList<ThemeProvider>(this.session.getAllProviders(ThemeProvider.class));
            Collections.sort(this.providers, (o1, o2) -> o2.getProviderPriority() - o1.getProviderPriority());
        }
        return this.providers;
    }

    private static class ExtendingTheme
    implements Theme {
        private final List<Theme> themes;
        private final Set<ThemeResourceProvider> themeResourceProviders;
        private Properties properties;
        private final ConcurrentHashMap<String, ConcurrentHashMap<Locale, Map<Locale, Properties>>> messages = new ConcurrentHashMap();
        private Pattern compiledContentHashPattern;
        private static final Pattern LATIN_CHARACTERS;

        public ExtendingTheme(List<Theme> themes, Set<ThemeResourceProvider> themeResourceProviders) {
            this.themes = themes;
            this.themeResourceProviders = themeResourceProviders;
            try {
                Object contentHashPattern = this.getProperties().get("contentHashPattern");
                if (contentHashPattern != null) {
                    this.compiledContentHashPattern = Pattern.compile(contentHashPattern.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.themes.get(0).getName();
        }

        public String getParentName() {
            return this.themes.get(0).getParentName();
        }

        public String getImportName() {
            return this.themes.get(0).getImportName();
        }

        public Theme.Type getType() {
            return this.themes.get(0).getType();
        }

        public URL getTemplate(String name) throws IOException {
            URL template;
            for (Theme theme : this.themes) {
                template = theme.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                template = themeResourceProvider.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) throws IOException {
            InputStream resource;
            for (Theme theme : this.themes) {
                resource = theme.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                resource = themeResourceProvider.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public Properties getMessages(Locale locale) throws IOException {
            return this.getMessages("messages", locale);
        }

        public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
            Map<Locale, Properties> messagesByLocale = this.getMessagesByLocale(baseBundlename, locale);
            return LocaleUtil.mergeGroupedMessages(locale, messagesByLocale);
        }

        public Properties getEnhancedMessages(RealmModel realm, Locale locale) throws IOException {
            Map<Locale, Properties> messagesByLocale = this.getMessagesByLocale("messages", locale);
            return LocaleUtil.enhancePropertiesWithRealmLocalizationTexts(realm, locale, messagesByLocale);
        }

        public boolean hasContentHash(String path) throws IOException {
            return this.compiledContentHashPattern != null && this.compiledContentHashPattern.matcher(path).matches();
        }

        private Map<Locale, Properties> getMessagesByLocale(String baseBundlename, Locale locale) throws IOException {
            if (this.messages.get(baseBundlename) == null || this.messages.get(baseBundlename).get(locale) == null) {
                Locale parent = DefaultThemeManager.getParent(locale);
                Map parentMessages = parent == null ? Collections.emptyMap() : this.getMessagesByLocale(baseBundlename, parent);
                Properties currentMessages = new Properties();
                HashMap<Locale, Properties> groupedMessages = new HashMap<Locale, Properties>(parentMessages);
                groupedMessages.put(locale, currentMessages);
                for (ThemeResourceProvider t : this.themeResourceProviders) {
                    currentMessages.putAll((Map<?, ?>)t.getMessages(baseBundlename, locale));
                }
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties m = itr.previous().getMessages(baseBundlename, locale);
                    if (m == null) continue;
                    currentMessages.putAll((Map<?, ?>)m);
                }
                this.addlocaleTranslations(locale, currentMessages);
                this.messages.putIfAbsent(baseBundlename, new ConcurrentHashMap());
                this.messages.get(baseBundlename).putIfAbsent(locale, groupedMessages);
                return groupedMessages;
            }
            return this.messages.get(baseBundlename).get(locale);
        }

        protected void addlocaleTranslations(Locale locale, Properties m) throws IOException {
            for (String l : this.getProperties().getProperty("locales", "").split(",")) {
                String key = "locale_" + (l = l.trim());
                Object label = m.getProperty(key);
                if (label != null) continue;
                String rl = l;
                if (l.equals("zh-CN")) {
                    rl = "zh-Hans";
                } else if (l.equals("zh-TW")) {
                    rl = "zh-Hant";
                }
                Locale loc = Locale.forLanguageTag(rl);
                label = this.capitalize(loc.getDisplayName(locale), locale);
                if (!Objects.equals(loc, locale)) {
                    label = (String)label + " (" + this.capitalize(loc.getDisplayName(loc), loc) + ")";
                }
                m.put(key, label);
            }
        }

        private String capitalize(String name, Locale locale) {
            if (LATIN_CHARACTERS.matcher(name).matches()) {
                return name.substring(0, 1).toUpperCase(locale) + name.substring(1);
            }
            return name;
        }

        public Properties getProperties() throws IOException {
            if (this.properties == null) {
                Properties properties = new Properties();
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties p = itr.previous().getProperties();
                    if (p == null) continue;
                    properties.putAll((Map<?, ?>)p);
                }
                this.substituteProperties(properties);
                this.properties = properties;
                return properties;
            }
            return this.properties;
        }

        private void substituteProperties(Properties properties) {
            for (String propertyName : properties.stringPropertyNames()) {
                properties.setProperty(propertyName, StringPropertyReplacer.replaceProperties((String)properties.getProperty(propertyName), arg_0 -> ((SystemEnvProperties)SystemEnvProperties.UNFILTERED).getProperty(arg_0)));
            }
        }

        static {
            Pattern p;
            try {
                p = Pattern.compile("(\\p{L1}|\\p{InLATIN_EXTENDED_A}|\\p{InLATIN_EXTENDED_B}|\\p{InLATIN_EXTENDED_C}|\\p{InLATIN_EXTENDED_D}|\\p{InLATIN_EXTENDED_E}).*");
            }
            catch (PatternSyntaxException ex) {
                log.warn((Object)"unable to create regex for latin characters", (Throwable)ex);
                p = Pattern.compile("[a-zA-Z]");
            }
            LATIN_CHARACTERS = p;
        }
    }
}

