/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class TwoPhaseLoad {
    private TwoPhaseLoad() {
    }

    public static void addUninitializedCachedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, Object version, SharedSessionContractImplementor session) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder entityHolder = persistenceContext.addEntityHolder(key, object);
        EntityEntry entityEntry = persistenceContext.addEntry(object, Status.LOADING, null, null, key.getIdentifier(), version, lockMode, true, persister, false);
        entityHolder.setEntityEntry(entityEntry);
        Object proxy = entityHolder.getProxy();
        if (proxy != null) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
            assert (lazyInitializer != null);
            lazyInitializer.setImplementation(object);
        }
    }
}

