/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class CloseOptions {
    private GroupMembershipOperation operation = GroupMembershipOperation.DEFAULT;
    private Optional<Duration> timeout = Optional.empty();

    private CloseOptions() {
    }

    public static CloseOptions timeout(Duration timeout) {
        return new CloseOptions().withTimeout(timeout);
    }

    public static CloseOptions groupMembershipOperation(GroupMembershipOperation operation) {
        return new CloseOptions().withGroupMembershipOperation(operation);
    }

    public CloseOptions withTimeout(Duration timeout) {
        this.timeout = Optional.ofNullable(timeout);
        return this;
    }

    public CloseOptions withGroupMembershipOperation(GroupMembershipOperation operation) {
        this.operation = Objects.requireNonNull(operation, "operation should not be null");
        return this;
    }

    public GroupMembershipOperation groupMembershipOperation() {
        return this.operation;
    }

    public Optional<Duration> timeout() {
        return this.timeout;
    }

    public static enum GroupMembershipOperation {
        LEAVE_GROUP,
        REMAIN_IN_GROUP,
        DEFAULT;

    }
}

