/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemappingCoverageAnnotator
extends SimpleCoverageAnnotator {
    public RemappingCoverageAnnotator(Project project) {
        super(project);
    }

    @Override
    protected void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, Project project, SimpleCoverageAnnotator.CoverageAnnotatorRunner annotator) {
        String pathToRemap;
        if (contentRoot == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (suite == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(1);
        }
        if (dataManager == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(2);
        }
        if (data == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (!contentRoot.isValid()) {
            return;
        }
        Map<String, String> normalizedFiles2Files = this.getNormalizedFiles2FilesMapping(data);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        BaseCoverageAnnotator.DirCoverageInfo info = this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), index, suite.getCoverageEngine(), new HashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
        if (info == null && (pathToRemap = RemappingCoverageAnnotator.findPathToRemap(data.getClasses().keySet(), contentRoot)) != null) {
            data = RemappingCoverageAnnotator.remapData(data, pathToRemap, contentRoot);
            suite.setCoverageData(data);
            for (CoverageSuite suiteSuite : suite.getSuites()) {
                suiteSuite.setCoverageData(data);
            }
            normalizedFiles2Files = this.getNormalizedFiles2FilesMapping(data);
            this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), index, suite.getCoverageEngine(), new HashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
        }
    }

    @Nullable
    private static String findPathToRemap(Set<String> files, VirtualFile contentRoot) {
        Comparator<String> comparator = Comparator.comparingInt(o -> StringUtil.countChars((CharSequence)o, (char)'/'));
        List sortedFiles = ContainerUtil.reverse((List)ContainerUtil.sorted(files, comparator));
        List suspects = sortedFiles.subList(0, Math.min(3, sortedFiles.size()));
        String pathToRemap = null;
        for (String suspect : suspects) {
            String[] pathParts = suspect.split("/");
            Object path = "";
            String oldValue = pathToRemap;
            for (String part : pathParts) {
                String relPath = StringUtil.substringAfter((String)suspect, (String)(path = (String)path + part + "/"));
                if (relPath == null || contentRoot.findFileByRelativePath(relPath) == null) continue;
                pathToRemap = StringUtil.substringBeforeLast((String)path, (String)"/");
                break;
            }
            if (oldValue == null || oldValue.equals(pathToRemap)) continue;
            pathToRemap = null;
            break;
        }
        return pathToRemap;
    }

    @NotNull
    private static ProjectData remapData(@NotNull ProjectData oldData, @NotNull String oldPath, @NotNull VirtualFile contentRoot) {
        if (oldData == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(4);
        }
        if (oldPath == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(5);
        }
        if (contentRoot == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(6);
        }
        ProjectData newData = new ProjectData();
        oldData.getClasses().forEach((name, oldClass) -> {
            String relPath = StringUtil.substringAfter((String)name, (String)oldPath);
            Object newPath = name;
            if (relPath != null) {
                VirtualFile targetFile = contentRoot.findFileByRelativePath(relPath);
                newPath = targetFile != null ? targetFile.getCanonicalPath() : contentRoot.getPath() + relPath;
            }
            ClassData newClass = newData.getOrCreateClassData((String)newPath);
            newClass.setLines((LineData[])oldClass.getLines());
        });
        ProjectData projectData = newData;
        if (projectData == null) {
            RemappingCoverageAnnotator.$$$reportNull$$$0(7);
        }
        return projectData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/RemappingCoverageAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/RemappingCoverageAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "remapData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remapData";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

