/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.ExternalDependencyId;

public final class DefaultExternalDependencyId
implements ExternalDependencyId,
Serializable {
    private static final long serialVersionUID = 1L;
    private String group;
    private String name;
    private String version;
    @NotNull
    private String packaging = "jar";
    @Nullable
    private String classifier;

    public DefaultExternalDependencyId() {
    }

    public DefaultExternalDependencyId(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public DefaultExternalDependencyId(ExternalDependencyId dependencyId) {
        this(dependencyId.getGroup(), dependencyId.getName(), dependencyId.getVersion());
        this.packaging = dependencyId.getPackaging();
        this.classifier = dependencyId.getClassifier();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    @NotNull
    public String getPackaging() {
        String string = this.packaging;
        if (string == null) {
            DefaultExternalDependencyId.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setPackaging(@NotNull String packaging) {
        if (packaging == null) {
            DefaultExternalDependencyId.$$$reportNull$$$0(1);
        }
        this.packaging = packaging;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(@Nullable String classifier) {
        this.classifier = classifier;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        StringBuilder buf = new StringBuilder();
        if (this.group != null) {
            buf.append(this.group).append(':');
        }
        if (this.name != null) {
            buf.append(this.name);
        }
        if (!"jar".equals(this.packaging)) {
            buf.append(':').append(this.packaging);
        }
        if (this.classifier != null) {
            buf.append(':').append(this.classifier);
        }
        if (this.version != null) {
            buf.append(':').append(this.version);
        }
        String string = buf.toString();
        if (string == null) {
            DefaultExternalDependencyId.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExternalDependencyId id = (DefaultExternalDependencyId)o;
        return Objects.equals(this.group, id.group) && Objects.equals(this.name, id.name) && Objects.equals(this.packaging, id.packaging) && Objects.equals(this.classifier, id.classifier) && Objects.equals(this.version, id.version);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.packaging, this.classifier, this.version);
    }

    public String toString() {
        return this.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/DefaultExternalDependencyId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packaging";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackaging";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/DefaultExternalDependencyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPackaging";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

