/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TransformBackedProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    protected final Class<OUT> type;
    protected final ProviderInternal<? extends IN> provider;
    protected final Transformer<? extends OUT, ? super IN> transformer;

    public TransformBackedProvider(@Nullable Class<OUT> type, ProviderInternal<? extends IN> provider, Transformer<? extends OUT, ? super IN> transformer) {
        this.type = type;
        this.transformer = transformer;
        this.provider = provider;
    }

    @Override
    public @Nullable Class<OUT> getType() {
        return this.type;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationScopeContext ignored = this.openScope();){
            ValueSupplier.ValueProducer valueProducer = this.provider.getProducer();
            return valueProducer;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ExecutionTimeValue<IN> value = this.provider.calculateExecutionTimeValue();
            if (value.hasChangingContent()) {
                ValueSupplier.ExecutionTimeValue executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(new TransformBackedProvider<OUT, IN>(this.type, value.toProvider(), this.transformer));
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<OUT> executionTimeValue = ValueSupplier.ExecutionTimeValue.value(this.mapValue(context, value.toValue()));
            return executionTimeValue;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends OUT> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            this.beforeRead(context);
            ValueSupplier.Value<? extends IN> value = this.provider.calculateValue(consumer);
            ValueSupplier.Value<OUT> value2 = this.mapValue(context, value);
            return value2;
        }
    }

    protected  @NonNull ValueSupplier.Value<OUT> mapValue(EvaluationScopeContext context, ValueSupplier.Value<? extends IN> value) {
        if (value.isMissing()) {
            return value.asType();
        }
        return value.transform(this.transformer);
    }

    protected void beforeRead(EvaluationScopeContext context) {
        this.provider.getProducer().visitContentProducerTasks((Action<? super Task>)((Action)producer -> {
            if (!producer.getState().getExecuted()) {
                throw new InvalidUserCodeException(String.format("Querying the mapped value of %s before %s has completed is not supported", this.provider, producer));
            }
        }));
    }

    @Override
    protected String toStringNoReentrance() {
        return "map(" + (this.type == null ? "" : this.type.getName() + " ") + this.provider + ")";
    }
}

