/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.EffectiveJavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonForkOptionsBuilder {
    private static final List<String> UNRELIABLE_OPTIONS = Arrays.asList("-cp", "-classpath", "--class-path", "-p", "--module-path", "--upgrade-module-path", "--patch-module");
    private static final List<String> UNRELIABLE_OPTION_PREFIXES = Arrays.asList("-Xbootclasspath", "-javaagent", "-agentpath");
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonForkOptionsBuilder.class);
    private final JavaForkOptionsInternal javaForkOptions;
    private final JavaForkOptionsFactory javaForkOptionsFactory;
    private KeepAliveMode keepAliveMode = KeepAliveMode.DAEMON;
    private ClassLoaderStructure classLoaderStructure = null;

    public DaemonForkOptionsBuilder(JavaForkOptionsFactory forkOptionsFactory) {
        this.javaForkOptions = forkOptionsFactory.newJavaForkOptions();
        this.javaForkOptionsFactory = forkOptionsFactory;
    }

    public DaemonForkOptionsBuilder keepAliveMode(KeepAliveMode keepAliveMode) {
        this.keepAliveMode = keepAliveMode;
        return this;
    }

    public DaemonForkOptionsBuilder javaForkOptions(JavaForkOptions javaForkOptions) {
        javaForkOptions.copyTo((JavaForkOptions)this.javaForkOptions);
        return this;
    }

    public DaemonForkOptionsBuilder withClassLoaderStructure(ClassLoaderStructure classLoaderStructure) {
        this.classLoaderStructure = classLoaderStructure;
        return this;
    }

    public DaemonForkOptions build() {
        List jvmArgs;
        Optional<String> unreliableArgument;
        EffectiveJavaForkOptions forkOptions = this.javaForkOptionsFactory.toEffectiveJavaForkOptions(this.javaForkOptions);
        if (OperatingSystem.current().isWindows() && this.keepAliveMode == KeepAliveMode.DAEMON && (unreliableArgument = DaemonForkOptionsBuilder.findUnreliableArgument(jvmArgs = forkOptions.getJvmOptions().getAllJvmArgs())).isPresent()) {
            LOGGER.info("Worker requested to be persistent, but the JVM argument '{}' may make the worker unreliable when reused across multiple builds. Worker will expire at the end of the build session.", (Object)unreliableArgument.get());
            return new DaemonForkOptions(forkOptions, KeepAliveMode.SESSION, this.classLoaderStructure);
        }
        return new DaemonForkOptions(forkOptions, this.keepAliveMode, this.classLoaderStructure);
    }

    @VisibleForTesting
    static Optional<String> findUnreliableArgument(List<String> jvmArgs) {
        for (String jvmArg : jvmArgs) {
            if (!jvmArg.startsWith("-")) continue;
            if (UNRELIABLE_OPTIONS.contains(jvmArg)) {
                return Optional.of(jvmArg);
            }
            for (String prefix : UNRELIABLE_OPTION_PREFIXES) {
                if (!jvmArg.startsWith(prefix)) continue;
                return Optional.of(jvmArg);
            }
        }
        return Optional.empty();
    }
}

