/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.widgets.table.GTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;

public class DragDropTableSelectionMouseListener
extends MouseAdapter {
    private boolean consuming = false;
    private boolean didDrag = false;
    private GTable table;

    public DragDropTableSelectionMouseListener(GTable table) {
        this.table = table;
        this.install();
    }

    private void install() {
        MouseListener[] oldMouseListeners = this.table.getMouseListeners();
        MouseMotionListener[] oldMouseMotionListeners = this.table.getMouseMotionListeners();
        for (MouseListener mouseListener : oldMouseListeners) {
            this.table.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : oldMouseMotionListeners) {
            this.table.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        for (EventListener eventListener : oldMouseListeners) {
            this.table.addMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : oldMouseMotionListeners) {
            this.table.addMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.consuming = this.maybeConsumeEvent(e);
        this.didDrag = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.consuming) {
            return;
        }
        this.maybeConsumeEvent(e);
        this.consuming = false;
        if (!this.didDrag) {
            this.table.clearSelection();
            int row = this.table.rowAtPoint(e.getPoint());
            this.table.selectRow(row);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.consuming) {
            return;
        }
        e.consume();
        this.didDrag = true;
    }

    private boolean maybeConsumeEvent(MouseEvent e) {
        if (!this.isBasicLeftClick(e)) {
            return false;
        }
        int row = this.table.rowAtPoint(e.getPoint());
        if (this.table.isRowSelected(row)) {
            e.consume();
            return true;
        }
        return false;
    }

    private boolean isBasicLeftClick(MouseEvent e) {
        if (e.getButton() != 1) {
            return false;
        }
        if (e.getClickCount() > 1) {
            return false;
        }
        return !e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && !e.isMetaDown();
    }
}

