/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.multilisting;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.MultiRowLayout;
import docking.widgets.fieldpanel.support.RowLayout;
import ghidra.app.util.viewer.field.DummyFieldFactory;
import ghidra.app.util.viewer.proxy.EmptyProxy;

class MultiLayout {
    private Layout[] layouts;

    public MultiLayout() {
    }

    public MultiLayout(Layout[] layouts, DummyFieldFactory factory) {
        this.layouts = layouts;
        MultiRowLayout.RowHeights[] allHeights = new MultiRowLayout.RowHeights[layouts.length];
        int id = this.getDefaultID(layouts);
        for (int i = 0; i < layouts.length; ++i) {
            MultiRowLayout layout = (MultiRowLayout)layouts[i];
            if (layout == null) {
                Field[] fields = new Field[]{factory.getField(EmptyProxy.EMPTY_PROXY, 0)};
                layout = new MultiRowLayout(new RowLayout(fields, id), 1);
                layouts[i] = layout;
            }
            allHeights[i] = layout.getRowHeights();
        }
        int n = allHeights.length;
        MultiRowLayout.RowHeights combinedRowHeights = new MultiRowLayout.RowHeights();
        for (int i = 0; i < n; ++i) {
            combinedRowHeights.merge(allHeights[i]);
        }
        for (Layout layout : layouts) {
            ((MultiRowLayout)layout).align(combinedRowHeights);
        }
    }

    private int getDefaultID(Layout[] layouts1) {
        for (Layout layout : layouts1) {
            if (layout == null) continue;
            MultiRowLayout multiRowLayout = (MultiRowLayout)layout;
            return multiRowLayout.getFirstRowID();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.layouts == null;
    }

    public Layout getLayout(int modelID) {
        return this.layouts[modelID];
    }
}

