/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceBaseCodeUnitsView;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.util.TraceRegisterUtils;

public interface InternalBaseCodeUnitsView<T extends TraceCodeUnit>
extends TraceBaseCodeUnitsView<T> {
    public AddressSpace getSpace();

    @Override
    default public T getForRegister(TracePlatform platform, long snap, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        Object candidate = this.getContaining(snap, range.getMinAddress());
        if (candidate == null) {
            return null;
        }
        int cmpMax = range.getMaxAddress().compareTo((Object)candidate.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        if (cmpMax == 0 && candidate.getMinAddress().equals((Object)range.getMinAddress())) {
            return candidate;
        }
        if (!(candidate instanceof TraceData)) {
            return null;
        }
        TraceData data = (TraceData)candidate;
        return (T)TraceRegisterUtils.seekComponent(data, range);
    }

    @Override
    default public T getContaining(TracePlatform platform, long snap, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        Object candidate = this.getContaining(snap, range.getMinAddress());
        if (candidate == null) {
            return null;
        }
        int cmpMax = range.getMaxAddress().compareTo((Object)candidate.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        return candidate;
    }

    @Override
    default public Iterable<? extends T> get(TracePlatform platform, long snap, Register register, boolean forward) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        return this.get(snap, range, forward);
    }
}

