/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.DockingWindowManager;
import docking.DockingWindowsContextSensitiveHelpListener;
import docking.GlobalMenuAndToolBarManager;
import docking.MenuBarMenuHandler;
import docking.MouseBindingMouseEventDispatcher;
import docking.PopupActionManager;
import docking.PopupMenuContext;
import docking.action.DockingActionIf;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import ghidra.util.HelpLocation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;

public class ActionToGuiMapper {
    private Set<DockingActionIf> globalActions = new LinkedHashSet<DockingActionIf>();
    private MenuHandler menuBarMenuHandler;
    private MenuGroupMap menuGroupMap = new MenuGroupMap();
    private GlobalMenuAndToolBarManager menuAndToolBarManager;
    private PopupActionManager popupActionManager;

    ActionToGuiMapper(DockingWindowManager winMgr) {
        this.menuBarMenuHandler = new MenuBarMenuHandler(winMgr);
        this.menuAndToolBarManager = new GlobalMenuAndToolBarManager(winMgr, this.menuBarMenuHandler, this.menuGroupMap);
        this.popupActionManager = new PopupActionManager(winMgr, this.menuGroupMap);
        DockingWindowsContextSensitiveHelpListener.install();
        MouseBindingMouseEventDispatcher.install();
    }

    static void setHelpLocation(JComponent c, HelpLocation helpLocation) {
        DockingWindowManager.getHelpService().registerHelp((Object)c, helpLocation);
    }

    void addToolAction(DockingActionIf action) {
        if (this.globalActions.add(action)) {
            this.popupActionManager.addAction(action);
            this.menuAndToolBarManager.addAction(action);
        }
    }

    void removeToolAction(DockingActionIf action) {
        this.popupActionManager.removeAction(action);
        this.menuAndToolBarManager.removeAction(action);
        this.globalActions.remove(action);
    }

    Set<DockingActionIf> getGlobalActions() {
        return this.globalActions;
    }

    void setActive(boolean active) {
        if (!active) {
            this.dismissMenus();
            DockingWindowManager.clearMouseOverHelp();
        }
    }

    private void dismissMenus() {
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    void update() {
        this.menuAndToolBarManager.update();
        this.contextChanged();
    }

    void dispose() {
        this.popupActionManager.dispose();
        this.menuAndToolBarManager.dispose();
        this.globalActions.clear();
    }

    void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        this.menuGroupMap.setMenuGroup(menuPath, group, menuSubGroup);
    }

    MenuHandler getMenuHandler() {
        return this.menuBarMenuHandler;
    }

    void contextChanged() {
        this.menuAndToolBarManager.contextChanged();
    }

    PopupActionManager getPopupActionManager() {
        return this.popupActionManager;
    }

    public MenuGroupMap getMenuGroupMap() {
        return this.menuGroupMap;
    }

    public void showPopupMenu(ComponentPlaceholder componentInfo, PopupMenuContext popupContext) {
        this.popupActionManager.popupMenu(componentInfo, popupContext);
    }
}

