/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingServicePlugin;
import ghidra.app.plugin.core.debug.service.modules.InfoPerTrace;
import ghidra.app.plugin.core.debug.service.modules.MappingEntry;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.util.Msg;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;

class InfoPerProgram
implements DomainObjectListener {
    private final DebuggerStaticMappingServicePlugin plugin;
    final Program program;
    final NavMultiMap<Address, MappingEntry> inboundByStaticAddress = new NavMultiMap();
    final URL url;

    InfoPerProgram(DebuggerStaticMappingServicePlugin plugin, Program program) {
        this.plugin = plugin;
        this.program = program;
        this.url = ProgramURLUtils.getUrlFromProgram(program);
        program.addListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if ((ev.contains((EventType)DomainObjectEvent.FILE_CHANGED) || ev.contains((EventType)DomainObjectEvent.RENAMED)) && !this.urlMatches()) {
            CompletableFuture.runAsync(this.plugin::programsChanged, this.plugin.executor);
        }
    }

    boolean urlMatches() {
        return Objects.equals(this.url, ProgramURLUtils.getUrlFromProgram(this.program));
    }

    void clearProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, MappingEntry me) {
        assert (me.program == this.program);
        this.inboundByStaticAddress.remove(me.getStaticAddress(), me);
        me.clearProgram(cc, this.program);
    }

    void fillProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, MappingEntry me) {
        assert (me.getStaticProgramUrl().equals(ProgramURLUtils.getUrlFromProgram(this.program)));
        me.fillProgram(cc, this.program);
        this.inboundByStaticAddress.put(me.getStaticAddress(), me);
    }

    void clearEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc) {
        if (this.url == null) {
            return;
        }
        for (InfoPerTrace info : this.plugin.traceInfoByTrace.values()) {
            info.clearEntriesForProgram(cc, this);
        }
    }

    void fillEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc) {
        if (this.url == null) {
            return;
        }
        for (InfoPerTrace info : this.plugin.traceInfoByTrace.values()) {
            info.fillEntriesForProgram(cc, this);
        }
    }

    Set<TraceLocation> getOpenMappedTraceLocations(Address address) {
        HashSet<TraceLocation> result = new HashSet<TraceLocation>();
        for (Set set : this.inboundByStaticAddress.map.headMap(address, true).values()) {
            for (MappingEntry me : set) {
                if (me.mapping.isDeleted()) {
                    Msg.warn((Object)this, (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                    continue;
                }
                if (!me.isInProgramRange(address)) continue;
                result.add(me.mapProgramAddressToTraceLocation(address));
            }
        }
        return result;
    }

    TraceLocation getOpenMappedTraceLocation(Trace trace, Address address, long snap) {
        for (Set set : this.inboundByStaticAddress.map.headMap(address, true).values()) {
            for (MappingEntry me : set) {
                if (me.mapping.isDeleted()) {
                    Msg.warn((Object)this, (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                    continue;
                }
                if (me.getTrace() != trace || !me.isInProgramRange(address) || !me.isInTraceLifespan(snap)) continue;
                return me.mapProgramAddressToTraceLocation(address);
            }
        }
        return null;
    }

    private void collectOpenMappedViews(Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> result, AddressRange rng) {
        for (Set set : this.inboundByStaticAddress.map.headMap(rng.getMaxAddress(), true).values()) {
            for (MappingEntry me : set) {
                if (me.mapping.isDeleted()) {
                    Msg.warn((Object)this, (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                    continue;
                }
                if (!me.isInProgramRange(rng)) continue;
                AddressRange srcRange = me.getStaticRange().intersect(rng);
                AddressRange dstRange = me.mapProgramRangeToTrace(rng);
                result.computeIfAbsent(me.getTraceSpan(), p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRange, dstRange));
            }
        }
    }

    Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set) {
        HashMap<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
        for (AddressRange rng : set) {
            this.collectOpenMappedViews(result, rng);
        }
        return Collections.unmodifiableMap(result);
    }

    static class NavMultiMap<K, V> {
        private final TreeMap<K, Set<V>> map = new TreeMap();

        NavMultiMap() {
        }

        public boolean put(K k, V v) {
            return this.map.computeIfAbsent(k, __ -> new HashSet()).add(v);
        }

        public boolean remove(K k, V v) {
            Set<V> set = this.map.get(k);
            if (set == null) {
                return false;
            }
            if (!set.remove(v)) {
                return false;
            }
            if (set.isEmpty()) {
                this.map.remove(k);
            }
            return true;
        }
    }
}

