/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.control.DebuggerControlPlugin;
import ghidra.debug.api.control.ControlMode;
import ghidra.util.HelpLocation;
import java.util.stream.Collectors;

class ControlModeAction
extends MultiStateDockingAction<ControlMode> {
    public static final String NAME = "Control Mode";
    public static final String DESCRIPTION = "Choose what to control and edit in dynamic views";
    public static final String GROUP = "Dbg4. Control";
    public static final String HELP_ANCHOR = "control_mode";
    private final DebuggerControlPlugin plugin;

    public ControlModeAction(DebuggerControlPlugin plugin) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setDescription(DESCRIPTION);
        this.setToolBarData(new ToolBarData(DebuggerResources.ICON_BLANK, GROUP, ""));
        this.setHelpLocation(new HelpLocation(this.getOwner(), HELP_ANCHOR));
        this.setActionStates(ControlMode.ALL.stream().map(m -> new ActionState(m.name, m.icon, m)).collect(Collectors.toList()));
        this.setEnabled(false);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.plugin.current.getTrace() != null;
    }

    protected boolean isStateEnabled(ActionState<ControlMode> state) {
        return ((ControlMode)state.getUserData()).isSelectable(this.plugin.current);
    }

    public void actionStateChanged(ActionState<ControlMode> newActionState, EventTrigger trigger) {
        this.plugin.activateControlMode(newActionState, trigger);
    }
}

