/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class ConstructTpl {
    private int numlabels = 0;
    private OpTpl[] vec;
    private HandleTpl result;

    public ConstructTpl() {
    }

    public ConstructTpl(OpTpl[] opvec) {
        this.vec = opvec;
        this.result = null;
    }

    public ConstructTpl(OpTpl[] opvec, HandleTpl res, int nmLabels) {
        this.vec = opvec;
        this.result = res;
        this.numlabels = nmLabels;
    }

    public int getNumLabels() {
        return this.numlabels;
    }

    public OpTpl[] getOpVec() {
        return this.vec;
    }

    public HandleTpl getResult() {
        return this.result;
    }

    public int decode(Decoder decoder) throws DecoderException {
        int sectionid = -1;
        this.numlabels = 0;
        int el = decoder.openElement(SlaFormat.ELEM_CONSTRUCT_TPL);
        int attrib = decoder.getNextAttributeId();
        while (attrib != 0) {
            if (attrib == SlaFormat.ATTRIB_LABELS.id()) {
                this.numlabels = (int)decoder.readSignedInteger();
            } else if (attrib == SlaFormat.ATTRIB_SECTION.id()) {
                sectionid = (int)decoder.readSignedInteger();
            }
            attrib = decoder.getNextAttributeId();
        }
        int handel = decoder.peekElement();
        if (handel == SlaFormat.ELEM_NULL.id()) {
            decoder.openElement();
            decoder.closeElement(handel);
            this.result = null;
        } else {
            this.result = new HandleTpl();
            this.result.decode(decoder);
        }
        ArrayList<OpTpl> oplist = new ArrayList<OpTpl>();
        while (decoder.peekElement() != 0) {
            OpTpl op = new OpTpl();
            op.decode(decoder);
            oplist.add(op);
        }
        this.vec = new OpTpl[oplist.size()];
        oplist.toArray(this.vec);
        decoder.closeElement(el);
        return sectionid;
    }
}

