/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModifierExMsType
extends AbstractMsType {
    public static final int PDB_ID = 5400;
    private RecordNumber modifiedRecordNumber;
    private List<Modifier> modifiers = new ArrayList<Modifier>();

    public ModifierExMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.modifiedRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        int count = reader.parseUnsignedShortVal();
        for (int i = 0; i < count; ++i) {
            Modifier modifier = Modifier.fromValue(reader.parseUnsignedShortVal());
            if (modifier == Modifier.INVALID) {
                // empty if block
            }
            this.modifiers.add(modifier);
        }
    }

    @Override
    public int getPdbId() {
        return 5400;
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder modBuilder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            modBuilder.append((Object)modifier);
        }
        modBuilder.append(this.pdb.getTypeRecord(this.modifiedRecordNumber));
        builder.insert(0, modBuilder);
    }

    public static enum Modifier {
        INVALID("INVALID ", 0),
        CONST("const ", 1),
        VOLATILE("volatile ", 2),
        UNALIGNED("__unaligned ", 3),
        HLSL_UNIFORM("__uniform__ ", 512),
        HLSL_LINE("__line__ ", 513),
        HLSL_TRIANGLE("__triangle__ ", 514),
        HLSL_LINEADJ("__lineadj__ ", 515),
        HLSL_TRIANGLEADJ("__triangleadj__ ", 516),
        HLSL_LINEAR("__linear__ ", 517),
        HLSL_CENTROID("__centroid__ ", 518),
        HLSL_CONSTINTERP("__constinterp__ ", 519),
        HLSL_NOPERSPECTIVE("__noperspective__ ", 520),
        HLSL_SAMPLE("__sample__ ", 521),
        HLSL_CENTER("__center__ ", 522),
        HLSL_SNORM("__snorm__ ", 523),
        HLSL_UNORM("__unorm__ ", 524),
        HLSL_PRECISE("__precise__ ", 525),
        HLSL_UAV_GLOBALLY_COHERENT("__uav_globally_coherent__ ", 526);

        private static final Map<Integer, Modifier> BY_VALUE;
        public final String label;
        public final int value;

        public void emit(StringBuilder builder) {
            builder.append(((Object)((Object)this)).getClass().getSimpleName());
        }

        public String toString() {
            return this.label;
        }

        public static Modifier fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private Modifier(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Modifier>();
            for (Modifier val : Modifier.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

