/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public interface MultiSelectionStrategy {
    public Shape getInitialShape(Point2D var1);

    default public void closeShape() {
    }

    public Shape updateShape(Point2D var1, Point2D var2);

    public static Rectangular rectangular() {
        return new Rectangular();
    }

    public static Arbitrary arbitrary() {
        return new Arbitrary();
    }

    public static class Rectangular
    implements MultiSelectionStrategy {
        RectangularShape shape;

        @Override
        public Shape getInitialShape(Point2D location) {
            this.shape = new Rectangle2D.Double(location.getX(), location.getY(), 0.0, 0.0);
            return this.shape;
        }

        @Override
        public Shape updateShape(Point2D down, Point2D out) {
            this.shape.setFrameFromDiagonal(down, out);
            return this.shape;
        }
    }

    public static class Arbitrary
    implements MultiSelectionStrategy {
        Path2D shape;

        @Override
        public Shape getInitialShape(Point2D location) {
            this.shape = new Path2D.Double();
            this.shape.moveTo(location.getX(), location.getY());
            return this.shape;
        }

        @Override
        public void closeShape() {
            this.shape.closePath();
        }

        @Override
        public Shape updateShape(Point2D down, Point2D out) {
            Path2D path = this.shape;
            path.lineTo(out.getX(), out.getY());
            return this.shape;
        }
    }
}

