/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.IndentField;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.OpenCloseField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.util.IndentFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

public class OpenCloseFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "+";

    public OpenCloseFieldFactory() {
        super(FIELD_NAME);
    }

    private OpenCloseFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.servicesChanged();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled) {
            return null;
        }
        boolean canOpen = false;
        int indentLevel = 0;
        boolean isLast = false;
        if (obj instanceof Data) {
            Data data = (Data)obj;
            canOpen = data.getNumComponents() > 0;
            indentLevel = this.computeIndentLevel(data);
            isLast = this.computeIsLast(data);
        }
        if (canOpen) {
            return new OpenCloseField(this, proxy, indentLevel, this.getMetrics(), this.startX + varWidth, this.width, isLast);
        }
        if (indentLevel > 0) {
            return new IndentField(this, proxy, indentLevel, this.getMetrics(), this.startX + varWidth, this.width, isLast);
        }
        return null;
    }

    private boolean computeIsLast(Data data) {
        Data d2;
        Data parent = data.getParent();
        return parent != null && (d2 = parent.getComponent(parent.getNumComponents() - 1)) == data;
    }

    private int computeIndentLevel(Data data) {
        int indentLevel = 0;
        while ((data = data.getParent()) != null) {
            ++indentLevel;
        }
        return indentLevel;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Data)) {
            return null;
        }
        Data data = (Data)obj;
        return new IndentFieldLocation(data.getProgram(), data.getMinAddress(), data.getComponentPath());
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof IndentFieldLocation)) {
            return null;
        }
        if (!this.hasSamePath(bf, programLoc)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, 0, 0);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5 || category == 6;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel fieldModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new OpenCloseFieldFactory(fieldModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

