/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.MangledContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DemanglerUtil {
    private static final Pattern LEADING_PARAMETER_SPACE_PATTERN = Pattern.compile(" ([\\*\\&\\)])");
    private static final Pattern TRAILING_PARAMETER_SPACE_PATTERN = Pattern.compile("([\\(\\,]) ");

    @Deprecated(since="11.3", forRemoval=true)
    public static DemangledObject demangle(String mangled) {
        List<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                MangledContext mangledContext = demangler.createMangledContext(mangled, null, null, null);
                DemangledObject demangledObject = demangler.demangle(mangledContext);
                if (demangledObject == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    @Deprecated(since="11.3", forRemoval=true)
    public static DemangledObject demangle(Program program, String mangled) {
        List<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                MangledContext mangledContext;
                DemangledObject demangledObject;
                if (!demangler.canDemangle(program) || (demangledObject = demangler.demangle(mangledContext = demangler.createMangledContext(mangled, null, null, null))) == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    public static List<DemangledObject> demangle(Program program, String mangled, Address address) {
        ArrayList<DemangledObject> results = new ArrayList<DemangledObject>();
        List<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                MangledContext mangledContext;
                DemangledObject demangledObject;
                if (!demangler.canDemangle(program) || (demangledObject = demangler.demangle(mangledContext = demangler.createMangledContext(mangled, null, program, address))) == null) continue;
                results.add(demangledObject);
            }
            catch (DemangledException demangledException) {}
        }
        return results;
    }

    private static List<Demangler> getDemanglers() {
        return ClassSearcher.getInstances(Demangler.class);
    }

    public static String stripSuperfluousSignatureSpaces(String str) {
        return DemanglerUtil.replace(DemanglerUtil.replace(str, LEADING_PARAMETER_SPACE_PATTERN), TRAILING_PARAMETER_SPACE_PATTERN);
    }

    private static String replace(String str, Pattern spaceCleanerPattern) {
        Matcher matcher = spaceCleanerPattern.matcher(str);
        StringBuilder buffy = new StringBuilder();
        while (matcher.find()) {
            String captureGroup = matcher.group(1);
            matcher.appendReplacement(buffy, captureGroup);
        }
        matcher.appendTail(buffy);
        return buffy.toString();
    }
}

