/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.codesignature;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CodeSignatureGenericBlob
implements StructConverter {
    protected int magic;
    protected long length;
    protected long base;

    public CodeSignatureGenericBlob(BinaryReader reader) throws IOException {
        this.base = reader.getPointerIndex();
        this.magic = reader.readNextInt();
        this.length = reader.readNextUnsignedInt();
    }

    public int getMagic() {
        return this.magic;
    }

    public long getLength() {
        return this.length;
    }

    public void markup(Program program, Address address, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.length - 8L == 0L) {
            return;
        }
        try {
            ArrayDataType dt = new ArrayDataType(BYTE, (int)this.length - 8, 1);
            Address hashAddr = address.add((long)this.toDataType().getLength());
            DataUtilities.createData((Program)program, (Address)hashAddr, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(hashAddr, CommentType.PRE, "CS_GenericBlob hash");
        }
        catch (Exception e) {
            log.appendMsg(CodeSignatureGenericBlob.class.getSimpleName(), "Failed to markup CS_GenericBlob");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("CS_GenericBlob", 0);
        struct.add(DWORD, "magic", "magic number");
        struct.add(DWORD, "length", "total length of blob");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

