/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxFunction
implements CoffSymbolAux {
    private int tagIndex;
    private int size;
    private int filePointerToLineNumber;
    private int nextEntryIndex;
    private byte[] unused;

    CoffSymbolAuxFunction(BinaryReader reader) throws IOException {
        this.tagIndex = reader.readNextInt();
        this.size = reader.readNextInt();
        this.filePointerToLineNumber = reader.readNextInt();
        this.nextEntryIndex = reader.readNextInt();
        this.unused = reader.readNextByteArray(2);
    }

    public int getTagIndex() {
        return this.tagIndex;
    }

    public int getSize() {
        return this.size;
    }

    public int getFilePointerToLineNumber() {
        return this.filePointerToLineNumber;
    }

    public int getNextEntryIndex() {
        return this.nextEntryIndex;
    }

    public byte[] getUnused() {
        return this.unused;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

