/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.ClassSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.util.NamespaceUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.List;
import javax.swing.Icon;

public class NamespaceCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_NAMESPACES_ICON = new GIcon("icon.plugin.symboltree.node.category.namespace.open");
    public static final Icon CLOSED_FOLDER_NAMESPACES_ICON = new GIcon("icon.plugin.symboltree.node.category.namespace.closed");

    public NamespaceCategoryNode(Program program) {
        super(SymbolCategory.NAMESPACE_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_NAMESPACES_ICON : CLOSED_FOLDER_NAMESPACES_ICON;
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        if (symbol.isExternal()) {
            return false;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == SymbolType.NAMESPACE) {
            return true;
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        return parentNamespace != null && parentNamespace != this.globalNamespace;
    }

    @Override
    public void symbolRemoved(Symbol symbol, Namespace oldNamespace, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        List parents = NamespaceUtils.getNamespaceParts((Namespace)oldNamespace);
        GTreeNode namespaceNode = this.getNamespaceNode((GTreeNode)this, parents, false, monitor);
        if (namespaceNode == null) {
            return;
        }
        SymbolNode key = SymbolNode.createKeyNode(symbol, symbol.getName(), this.program);
        GTreeNode foundNode = this.findNode(namespaceNode, key, false, monitor);
        if (foundNode == null) {
            return;
        }
        GTreeNode foundParent = foundNode.getParent();
        foundParent.removeNode(foundNode);
    }

    @Override
    public SymbolNode symbolAdded(Symbol symbol, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return null;
        }
        if (!this.supportsSymbol(symbol)) {
            return null;
        }
        NamespaceCategoryNode parentNode = this;
        if (symbol.isGlobal()) {
            return this.doAddSymbol(symbol, (GTreeNode)parentNode);
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        List parents = NamespaceUtils.getNamespaceParts((Namespace)parentNamespace);
        GTreeNode namespaceNode = this.getNamespaceNode((GTreeNode)this, parents, false, monitor);
        if (namespaceNode == null) {
            return null;
        }
        return this.doAddSymbol(symbol, namespaceNode);
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        if (!this.isLoaded() && !loadChildren || monitor.isCancelled()) {
            return null;
        }
        Symbol symbol = key.getSymbol();
        Namespace parent = symbol.getParentNamespace();
        List parents = NamespaceUtils.getNamespaceParts((Namespace)parent);
        GTreeNode namespaceNode = this.getNamespaceNode((GTreeNode)this, parents, loadChildren, monitor);
        if (namespaceNode != null) {
            return this.findNode(namespaceNode, key, loadChildren, monitor);
        }
        return this.findNode((GTreeNode)this, key, loadChildren, monitor);
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (!this.isSupportedLocalFlavor(flavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedLocalFlavor(DataFlavor flavor) {
        if (!this.isLocalDataFlavor(flavor)) {
            return false;
        }
        return flavor != ClassSymbolNode.LOCAL_DATA_FLAVOR;
    }
}

