/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class AddMemRefsCmd
extends BackgroundCommand<Program> {
    private Address fromAddr;
    private AddressSetView toSet;
    private RefType refType;
    private SourceType source;
    private int opIndex;

    public AddMemRefsCmd(Address fromAddr, AddressSetView toSet, RefType refType, SourceType source, int opIndex) {
        super("Add Memory References", true, true, false);
        this.fromAddr = fromAddr;
        this.toSet = toSet;
        this.refType = refType;
        this.source = source;
        this.opIndex = opIndex;
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        ReferenceManager refMgr = program.getReferenceManager();
        Listing listing = program.getListing();
        monitor.initialize(this.toSet.getNumAddresses());
        monitor.setMessage("Adding memory references...");
        int cnt = 0;
        AddressIterator iter = this.toSet.getAddresses(true);
        CodeUnit prevCodeUnit = null;
        while (!monitor.isCancelled() && iter.hasNext()) {
            CodeUnit cu;
            Address toAddr = iter.next();
            if (!(prevCodeUnit != null && prevCodeUnit.contains(toAddr) || (cu = this.getSmallestCodeUnitAt(listing, toAddr)) == null)) {
                prevCodeUnit = cu;
                refMgr.addMemoryReference(this.fromAddr, toAddr, this.refType, this.source, this.opIndex);
            }
            monitor.setProgress((long)(++cnt));
        }
        return true;
    }

    private CodeUnit getSmallestCodeUnitAt(Listing listing, Address addr) {
        CodeUnit cu = listing.getCodeUnitContaining(addr);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            if (data.getNumComponents() == 0 || data.isUnion() || data.isArray()) {
                return data;
            }
            long diff = addr.subtract(data.getMinAddress());
            return data.getPrimitiveAt((int)diff);
        }
        return cu;
    }
}

