/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class IconSizeControlGroup
implements ControlGroup {
    private static final String ICON_SIZE = "icon_size";
    private QuantityProperty<LengthUnit> mIconSize;
    private RevertingProperty mSetIconSize;
    private IconSizeChangeListener propertyChangeListener;

    IconSizeControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetIconSize = new RevertingProperty();
        this.mIconSize = new QuantityProperty(ICON_SIZE, 0.0, 256.0, 4.0, (Enum)LengthUnit.px);
        this.propertyChangeListener = new IconSizeChangeListener(this.mSetIconSize, (IPropertyControl)this.mIconSize);
        this.mSetIconSize.addPropertyChangeListener(this.propertyChangeListener);
        this.mIconSize.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mIconSize.appendToForm(formBuilder);
        this.mSetIconSize.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class IconSizeChangeListener
    extends ControlGroupChangeListener {
        public IconSizeChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        public void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MIconController iconController = (MIconController)IconController.getController();
            iconController.changeIconSize(node, enabled ? IconSizeControlGroup.this.mIconSize.getQuantifiedValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            Quantity iconSize = node.getSharedData().getIcons().getIconSize();
            Quantity viewedIconSize = IconController.getController().getIconSize(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            IconSizeControlGroup.this.mSetIconSize.setValue(iconSize != null);
            IconSizeControlGroup.this.mIconSize.setQuantifiedValue(viewedIconSize);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)IconSizeControlGroup.this.mSetIconSize);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)IconSizeControlGroup.this.mIconSize);
        }
    }
}

