/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowTab;
import net.infonode.docking.internal.HeavyWeightContainer;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowBarItem;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.gui.panel.ResizablePanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.util.Direction;

public class WindowBar
extends AbstractTabWindow {
    private RootWindow rootWindow;
    private Direction direction;
    private TabbedPanelContentPanel contentPanel;
    private ResizablePanel edgePanel;
    private HeavyWeightContainer heavyWeightEdgePanel;
    private PropertyChangeListener opaqueListener = new PropertyChangeListener(){

        @Override
        public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
            WindowBar.this.updateEdgePanelOpaque();
        }
    };

    WindowBar(RootWindow rootWindow, Direction direction) {
        super(false, new WindowBarItem());
        this.initMouseListener();
        this.rootWindow = rootWindow;
        this.contentPanel = new TabbedPanelContentPanel(this.getTabbedPanel(), new TabContentPanel(this.getTabbedPanel()){

            @Override
            public Dimension getMinimumSize() {
                if (WindowBar.this.getWindowBarProperties().getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                    return super.getMinimumSize();
                }
                return new Dimension(0, 0);
            }
        });
        this.direction = direction;
        WindowBarProperties properties = new WindowBarProperties();
        properties.getTabWindowProperties().addSuperObject(rootWindow.getRootWindowProperties().getTabWindowProperties());
        ((WindowBarItem)this.getWindowItem()).setWindowBarProperties(new WindowBarProperties(properties));
        this.getWindowBarProperties().addSuperObject(rootWindow.getRootWindowProperties().getWindowBarProperties());
        this.getWindowBarProperties().addSuperObject(WindowBarProperties.createDefault(this.direction));
        this.edgePanel = new ResizablePanel(rootWindow.isHeavyweightSupported(), this.direction.getOpposite(), this.contentPanel);
        this.edgePanel.setPreferredSize(new Dimension(200, 200));
        this.edgePanel.setComponent(this.contentPanel);
        this.edgePanel.setLayeredPane(rootWindow.getLayeredPane());
        this.edgePanel.setInnerArea(rootWindow.getWindowPanel());
        this.updateEdgePanelOpaque();
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.contentPanel.getProperties().getShapedPanelProperties().getMap(), ShapedPanelProperties.OPAQUE, this.opaqueListener);
        if (rootWindow.isHeavyweightSupported()) {
            this.edgePanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WindowBar.this.edgePanel.getParent() != null) {
                        WindowBar.this.edgePanel.getParent().repaint();
                    }
                }
            });
        }
        this.getEdgePanel().setVisible(false);
        this.setTabWindowProperties(this.getWindowBarProperties().getTabWindowProperties());
        this.init();
    }

    @Override
    public TabWindowProperties getTabWindowProperties() {
        return this.getWindowBarProperties().getTabWindowProperties();
    }

    public WindowBarProperties getWindowBarProperties() {
        return ((WindowBarItem)this.getWindowItem()).getWindowBarProperties();
    }

    @Override
    protected int addTabNoSelect(DockingWindow window, int index) {
        index = super.addTabNoSelect(window, index);
        window.setLastMinimizedDirection(this.direction);
        return index;
    }

    public void setContentPanelSize(int size) {
        this.edgePanel.setPreferredSize(this.direction.isHorizontal() ? new Dimension(size, 0) : new Dimension(0, size));
    }

    public int getContentPanelSize() {
        Dimension size = this.edgePanel.getPreferredSize();
        return this.direction.isHorizontal() ? size.width : size.height;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    @Override
    protected void showChildWindow(DockingWindow window) {
        int index = this.getChildWindowIndex(window);
        if (index != -1) {
            this.setSelectedTab(index);
        }
        super.showChildWindow(window);
    }

    Component getEdgePanel() {
        if (!this.rootWindow.isHeavyweightSupported()) {
            return this.edgePanel;
        }
        if (this.heavyWeightEdgePanel == null) {
            this.heavyWeightEdgePanel = new HeavyWeightContainer(this.edgePanel){

                @Override
                public void setVisible(boolean v) {
                    if (WindowBar.this.getRootWindow() != null) {
                        WindowBar.this.getRootWindow().paintImmediately(0, 0, WindowBar.this.getRootWindow().getWidth(), WindowBar.this.getRootWindow().getHeight());
                    }
                    super.setVisible(v);
                }
            };
            this.heavyWeightEdgePanel.setVisible(false);
        }
        return this.heavyWeightEdgePanel;
    }

    @Override
    protected void update() {
        this.edgePanel.setResizeWidth(this.getWindowBarProperties().getContentPanelEdgeResizeDistance());
        this.edgePanel.setContinuousLayout(this.getWindowBarProperties().getContinuousLayoutEnabled());
        this.edgePanel.setDragIndicatorColor(this.getWindowBarProperties().getDragIndicatorColor());
        this.getWindowBarProperties().getComponentProperties().applyTo(this, this.direction.getNextCW());
    }

    private void updateEdgePanelOpaque() {
        if (this.edgePanel != null) {
            BaseContainerUtil.setForcedOpaque(this.edgePanel, this.rootWindow.isHeavyweightSupported() || this.contentPanel.getProperties().getShapedPanelProperties().getOpaque());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isEnabled()) {
            Dimension size = super.getPreferredSize();
            int minWidth = this.getWindowBarProperties().getMinimumWidth();
            return new Dimension(Math.max(minWidth, size.width), Math.max(minWidth, size.height));
        }
        return new Dimension(0, 0);
    }

    @Override
    protected void tabSelected(WindowTab tab) {
        this.getEdgePanel().setVisible(tab != null);
        super.tabSelected(tab);
    }

    @Override
    protected boolean isInsideTabArea(Point p2) {
        return true;
    }

    @Override
    protected void clearFocus(View view) {
        super.clearFocus(view);
        if (view != null && !DockingUtil.isAncestor(this, view)) {
            this.getTabbedPanel().setSelectedTab(null);
        }
    }

    @Override
    public boolean isMinimized() {
        return true;
    }

    @Override
    protected boolean acceptsSplitWith(DockingWindow window) {
        return false;
    }

    @Override
    DropAction acceptDrop(Point p, DockingWindow window) {
        return this.isEnabled() ? super.acceptDrop(p, window) : null;
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getWindowBarProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new WindowBarProperties().getMap();
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(this.getContentPanelSize());
        out.writeBoolean(this.isEnabled());
        this.getWindowItem().writeSettings(out, context);
        super.write(out, context, viewWriter);
    }

    @Override
    protected DockingWindow newRead(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        this.setContentPanelSize(in.readInt());
        this.setEnabled(in.readBoolean());
        this.getWindowItem().readSettings(in, context);
        super.newRead(in, context, viewReader);
        return this;
    }

    @Override
    protected DockingWindow oldRead(ObjectInputStream in, ReadContext context) throws IOException {
        super.oldRead(in, context);
        this.setContentPanelSize(in.readInt());
        this.setEnabled(in.readBoolean());
        return this;
    }
}

