/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class TransformerSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(TransformerSettingsDialog.class);
    private static final String PROP_FOR_TRANSFORMER = "propertiesForTransformerWithId=";
    private static final Type PROPERTIES_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Gson GSON = new Gson();
    private final ResultSetViewer viewer;
    private final DBVEntity vEntitySrc;
    private final DBVEntity vEntity;
    private DBDAttributeBinding currentAttribute;
    private PropertyTreeViewer propertiesEditor;
    private PropertySourceCustom propertySource;
    private boolean selector;
    private List<? extends DBDAttributeTransformerDescriptor> transformerList;
    private Text infoText;
    private DBDAttributeTransformerDescriptor transformer;
    private Combo transformerCombo;
    private Table attributeTable;

    public TransformerSettingsDialog(ResultSetViewer viewer, DBDAttributeBinding currentAttribute, boolean selector) {
        super(viewer.getControl().getShell(), DBUtils.getObjectFullName((DBPNamedObject)viewer.getDataContainer(), (DBPEvaluationContext)DBPEvaluationContext.UI) + " transforms", null);
        this.viewer = viewer;
        this.currentAttribute = currentAttribute;
        this.selector = selector;
        this.vEntitySrc = this.currentAttribute == null ? viewer.getModel().getVirtualEntity(true) : DBVUtils.getVirtualEntity((DBDAttributeBinding)currentAttribute, (boolean)true);
        this.vEntity = new DBVEntity(this.vEntitySrc.getContainer(), this.vEntitySrc, this.vEntitySrc.getModel());
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite;
        Composite panel = composite = super.createDialogArea(parent);
        if (this.selector) {
            SashForm divider = new SashForm(composite, 256);
            divider.setSashWidth(10);
            divider.setLayoutData((Object)new GridData(1808));
            panel = divider;
            this.createAttributeSelectorArea(panel);
        } else if (this.currentAttribute != null) {
            this.detectTransformers();
        }
        this.createTransformSettingsArea(panel);
        if (this.currentAttribute != null) {
            this.updateTransformerInfo();
        }
        return parent;
    }

    private void createAttributeSelectorArea(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.attributeTable = new Table(panel, 67584);
        this.attributeTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        this.attributeTable.setLayoutData((Object)gd);
        UIUtils.executeOnResize((Control)this.attributeTable, () -> UIUtils.packColumns((Table)this.attributeTable, (boolean)true));
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)"Transforms");
        for (DBDAttributeBinding attr : this.viewer.getModel().getVisibleAttributes()) {
            TableItem attrItem = new TableItem(this.attributeTable, 0);
            attrItem.setData((Object)attr);
            attrItem.setText(0, attr.getName());
            attrItem.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attr, (boolean)true)));
            this.updateTransformItem(attrItem);
            if (this.currentAttribute != attr) continue;
            this.attributeTable.setSelection(attrItem);
        }
        this.attributeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformerSettingsDialog.this.updateAttributeSelection();
            }
        });
    }

    private void updateTransformItem(TableItem attrItem) {
        DBVTransformSettings settings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (settings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)settings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", settings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)settings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(settings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
    }

    private void updateAttributeSelection() {
        if (this.currentAttribute != null) {
            this.updateAttributeItemText();
        }
        if (this.attributeTable.getSelectionIndex() < 0) {
            this.currentAttribute = null;
        } else {
            this.currentAttribute = (DBDAttributeBinding)this.attributeTable.getItem(this.attributeTable.getSelectionIndex()).getData();
            this.detectTransformers();
            this.updateTransformerInfo();
        }
    }

    private void detectTransformers() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(this.currentAttribute, false);
        DBVTransformSettings settings = vAttr == null ? null : DBVUtils.getTransformSettings((DBVEntityAttribute)vAttr, (boolean)false);
        this.transformer = dataSource != null && settings != null && !CommonUtils.isEmpty((String)settings.getCustomTransformer()) ? DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(settings.getCustomTransformer()) : null;
        this.transformerList = DBWorkbench.getPlatform().getValueHandlerRegistry().findTransformers(this.currentAttribute.getDataSource(), (DBSTypedObject)this.currentAttribute, null);
    }

    private void updateTransformerInfo() {
        if (this.selector) {
            this.transformerCombo.removeAll();
            this.transformerCombo.add("Default");
            if (this.transformerList != null && this.selector) {
                for (DBDAttributeTransformerDescriptor dBDAttributeTransformerDescriptor : this.transformerList) {
                    this.transformerCombo.add(dBDAttributeTransformerDescriptor.getName());
                    if (dBDAttributeTransformerDescriptor != this.transformer) continue;
                    this.transformerCombo.select(this.transformerCombo.getItemCount() - 1);
                }
            }
            if (this.transformerCombo.getSelectionIndex() < 0) {
                this.transformerCombo.select(0);
            }
        }
        if (this.infoText != null) {
            if (this.transformer != null && this.transformer.getDescription() != null) {
                this.infoText.setText(this.transformer.getDescription());
            } else {
                this.infoText.setText("");
            }
        }
        if (this.transformer != null) {
            List list = this.transformer.getProperties();
            this.loadTransformerSettings(list);
        } else {
            this.loadTransformerSettings(Collections.emptyList());
        }
    }

    private void saveTransformerSettings() {
        this.propertiesEditor.saveEditorValues();
        if (this.currentAttribute == null) {
            return;
        }
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(this.currentAttribute, true);
        if (vAttr == null) {
            log.error((Object)("Can't get attribute settings for " + this.currentAttribute.getName()));
            return;
        }
        DBVTransformSettings settings = DBVUtils.getTransformSettings((DBVEntityAttribute)vAttr, (boolean)true);
        if (settings == null) {
            log.error((Object)("Can't get transform settings for " + this.currentAttribute.getName()));
            return;
        }
        if (this.selector) {
            settings.setCustomTransformer(this.transformer == null ? null : this.transformer.getId());
        }
        if (this.transformer == null) {
            settings.setTransformOptions(new LinkedHashMap());
        } else {
            Map properties = this.propertySource.getPropertiesWithDefaults();
            for (Map.Entry prop : properties.entrySet()) {
                if (prop.getValue() == null) continue;
                settings.setTransformOption(((String)prop.getKey()).toString(), (Object)prop.getValue().toString());
            }
            TransformerSettingsDialog.getDialogSettings().put(PROP_FOR_TRANSFORMER + this.transformer.getId(), GSON.toJson((Object)properties, PROPERTIES_TYPE));
        }
    }

    private void createTransformSettingsArea(final Composite composite) {
        Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)1);
        if (composite.getLayout() instanceof GridLayout) {
            settingsPanel.setLayoutData((Object)new GridData(1808));
        }
        if (this.selector || this.transformer != null) {
            Composite placeholder = UIUtils.createTitledComposite((Composite)settingsPanel, (String)"Transformer", (int)2, (int)768);
            if (!this.selector) {
                UIUtils.createLabelText((Composite)placeholder, (String)"Name", (String)this.transformer.getName(), (int)8);
            } else {
                this.transformerCombo = UIUtils.createLabelCombo((Composite)placeholder, (String)"Name", (int)12);
                this.transformerCombo.setLayoutData((Object)new GridData(768));
                this.transformerCombo.add("Default");
                this.transformerCombo.select(0);
                this.transformerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int selectionIndex = TransformerSettingsDialog.this.transformerCombo.getSelectionIndex();
                        if (selectionIndex == 0) {
                            TransformerSettingsDialog.this.transformer = null;
                            TransformerSettingsDialog.this.infoText.setText("N/A");
                            TransformerSettingsDialog.this.loadTransformerSettings(Collections.emptyList());
                        } else {
                            TransformerSettingsDialog.this.transformer = TransformerSettingsDialog.this.transformerList.get(selectionIndex - 1);
                            TransformerSettingsDialog.this.infoText.setText(CommonUtils.notEmpty((String)TransformerSettingsDialog.this.transformer.getDescription()));
                            TransformerSettingsDialog.this.loadTransformerSettings(TransformerSettingsDialog.this.transformer.getProperties());
                        }
                        TransformerSettingsDialog.this.updateTransformerInfo();
                        TransformerSettingsDialog.this.updateAttributeItemText();
                        composite.layout(true, true);
                    }
                });
            }
            Label infoLabel = UIUtils.createControlLabel((Composite)settingsPanel, (String)"Info");
            infoLabel.setLayoutData((Object)new GridData(2));
            this.infoText = new Text(settingsPanel, 72);
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            this.infoText.setLayoutData((Object)gd);
        }
        this.propertiesEditor = new PropertyTreeViewer(settingsPanel, 2048);
        this.propertiesEditor.getControl().setFocus();
    }

    private void updateAttributeItemText() {
        this.saveTransformerSettings();
        TableItem[] tableItemArray = this.attributeTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == this.currentAttribute) {
                this.updateTransformItem(item);
                break;
            }
            ++n2;
        }
    }

    private void loadTransformerSettings(Collection<? extends DBPPropertyDescriptor> properties) {
        String propertiesJson;
        Map transformOptions;
        DBVTransformSettings settings = this.currentAttribute == null ? null : DBVUtils.getTransformSettings((DBDAttributeBinding)this.currentAttribute, (boolean)false);
        Map map = transformOptions = settings == null ? null : settings.getTransformOptions();
        if (transformOptions == null && this.transformer != null && (propertiesJson = TransformerSettingsDialog.getDialogSettings().get(PROP_FOR_TRANSFORMER + this.transformer.getId())) != null) {
            transformOptions = (Map)GSON.fromJson(propertiesJson, PROPERTIES_TYPE);
        }
        if (transformOptions == null) {
            transformOptions = Collections.emptyMap();
        }
        this.propertySource = new PropertySourceCustom(properties, transformOptions);
        this.propertiesEditor.loadProperties((DBPPropertySource)this.propertySource);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        if (this.propertySource != null && this.propertySource.getProperties().length == 0 && !this.selector) {
            UIUtils.asyncExec(this::okPressed);
        }
    }

    protected void okPressed() {
        this.saveTransformerSettings();
        this.vEntitySrc.copyFrom(this.vEntity, this.vEntity.getModel());
        this.vEntitySrc.persistConfiguration();
        super.okPressed();
    }

    public boolean close() {
        if (this.vEntity != null) {
            this.vEntity.dispose();
        }
        return super.close();
    }

    @NotNull
    private static IDialogSettings getDialogSettings() {
        return UIUtils.getDialogSettings((String)TransformerSettingsDialog.class.getSimpleName());
    }
}

