/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.sql.QueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.QueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.utils.CommonUtils;

class MultiTabsQueryResultsContainer
extends QueryResultsContainer {
    private CTabItem resultsTab;

    MultiTabsQueryResultsContainer(@NotNull QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean singleQuery, boolean makeDefault) {
        super((Composite)queryProcessor.getOwner().getResultTabsContainer(), queryProcessor, resultSetNumber, resultSetIndex, singleQuery, makeDefault);
        this.resultsTab = this.createResultTab(makeDefault);
    }

    MultiTabsQueryResultsContainer(@NotNull QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer, boolean singleQuery) {
        super((Composite)queryProcessor.getOwner().getResultTabsContainer(), queryProcessor, resultSetNumber, resultSetIndex, dataContainer, singleQuery);
        this.resultsTab = this.createResultTab(false);
    }

    @NotNull
    private CTabItem createResultTab(boolean makeDefault) {
        SQLEditor owner = this.getOwner();
        int tabIndex = owner.obtainDesiredTabIndex(makeDefault);
        CTabItem resultsTab = new CTabItem(owner.getResultTabsContainer(), 0, tabIndex);
        resultsTab.setImage(SQLEditor.IMG_DATA_GRID);
        resultsTab.setData((Object)this);
        resultsTab.setShowClose(true);
        resultsTab.setText(owner.getResultsTabName(this.resultSetNumber, this.getQueryIndex(), null));
        CSSUtils.markConnectionTypeColor((Widget)resultsTab);
        resultsTab.setControl((Control)this.viewer.getControl());
        resultsTab.addDisposeListener(owner.resultTabDisposeListener);
        UIUtils.disposeControlOnItemDispose((CTabItem)resultsTab);
        return resultsTab;
    }

    @Override
    public void setTabName(@NotNull String tabName) {
        super.setTabName(tabName);
        this.resultsTab.setText(tabName);
    }

    public void setResultsTab(CTabItem resultsTab) {
        this.resultsTab = resultsTab;
    }

    @Override
    public void updateResultsName(@NotNull String resultSetName, @Nullable String toolTip) {
        CTabItem tabItem = this.resultsTab;
        if (tabItem != null && !tabItem.isDisposed()) {
            if (!CommonUtils.isEmpty((String)resultSetName)) {
                tabItem.setText(resultSetName);
            }
            if (toolTip != null) {
                tabItem.setToolTipText(toolTip);
            }
        }
    }

    @Override
    @NotNull
    public CTabItem getResultsTab() {
        return this.resultsTab;
    }

    @Override
    public boolean isPinned() {
        return this.isTabPinned(this.resultsTab);
    }

    @Override
    public void setPinned(boolean pinned) {
        this.setTabPinned(this.resultsTab, pinned);
    }

    @Override
    public void detach() {
        super.detach();
        if (this.detached) {
            this.resultsTab.dispose();
            this.resultsTab = null;
        }
    }

    @Override
    protected void dispose() {
        UIUtils.syncExec(() -> ((CTabItem)this.resultsTab).dispose());
    }
}

