﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/ComponentPropertyGroupRequest.h>
#include <aws/iottwinmaker/model/PropertyRequest.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {

/**
 * <p>An object that sets information about the composite component update
 * request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CompositeComponentRequest">AWS
 * API Reference</a></p>
 */
class CompositeComponentRequest {
 public:
  AWS_IOTTWINMAKER_API CompositeComponentRequest() = default;
  AWS_IOTTWINMAKER_API CompositeComponentRequest(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API CompositeComponentRequest& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The description of the component type.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CompositeComponentRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This is an object that maps strings to the properties to set in the component
   * type. Each string in the mapping must be unique to this object.</p>
   */
  inline const Aws::Map<Aws::String, PropertyRequest>& GetProperties() const { return m_properties; }
  inline bool PropertiesHasBeenSet() const { return m_propertiesHasBeenSet; }
  template <typename PropertiesT = Aws::Map<Aws::String, PropertyRequest>>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::Map<Aws::String, PropertyRequest>>
  CompositeComponentRequest& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  template <typename PropertiesKeyT = Aws::String, typename PropertiesValueT = PropertyRequest>
  CompositeComponentRequest& AddProperties(PropertiesKeyT&& key, PropertiesValueT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties.emplace(std::forward<PropertiesKeyT>(key), std::forward<PropertiesValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The property groups.</p>
   */
  inline const Aws::Map<Aws::String, ComponentPropertyGroupRequest>& GetPropertyGroups() const { return m_propertyGroups; }
  inline bool PropertyGroupsHasBeenSet() const { return m_propertyGroupsHasBeenSet; }
  template <typename PropertyGroupsT = Aws::Map<Aws::String, ComponentPropertyGroupRequest>>
  void SetPropertyGroups(PropertyGroupsT&& value) {
    m_propertyGroupsHasBeenSet = true;
    m_propertyGroups = std::forward<PropertyGroupsT>(value);
  }
  template <typename PropertyGroupsT = Aws::Map<Aws::String, ComponentPropertyGroupRequest>>
  CompositeComponentRequest& WithPropertyGroups(PropertyGroupsT&& value) {
    SetPropertyGroups(std::forward<PropertyGroupsT>(value));
    return *this;
  }
  template <typename PropertyGroupsKeyT = Aws::String, typename PropertyGroupsValueT = ComponentPropertyGroupRequest>
  CompositeComponentRequest& AddPropertyGroups(PropertyGroupsKeyT&& key, PropertyGroupsValueT&& value) {
    m_propertyGroupsHasBeenSet = true;
    m_propertyGroups.emplace(std::forward<PropertyGroupsKeyT>(key), std::forward<PropertyGroupsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  Aws::Map<Aws::String, PropertyRequest> m_properties;

  Aws::Map<Aws::String, ComponentPropertyGroupRequest> m_propertyGroups;
  bool m_descriptionHasBeenSet = false;
  bool m_propertiesHasBeenSet = false;
  bool m_propertyGroupsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
