﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/gamelift/GameLift_EXPORTS.h>
#include <aws/gamelift/model/GameServer.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GameLift {
namespace Model {
class ListGameServersResult {
 public:
  AWS_GAMELIFT_API ListGameServersResult() = default;
  AWS_GAMELIFT_API ListGameServersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GAMELIFT_API ListGameServersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A collection of game server objects that match the request.</p>
   */
  inline const Aws::Vector<GameServer>& GetGameServers() const { return m_gameServers; }
  template <typename GameServersT = Aws::Vector<GameServer>>
  void SetGameServers(GameServersT&& value) {
    m_gameServersHasBeenSet = true;
    m_gameServers = std::forward<GameServersT>(value);
  }
  template <typename GameServersT = Aws::Vector<GameServer>>
  ListGameServersResult& WithGameServers(GameServersT&& value) {
    SetGameServers(std::forward<GameServersT>(value));
    return *this;
  }
  template <typename GameServersT = GameServer>
  ListGameServersResult& AddGameServers(GameServersT&& value) {
    m_gameServersHasBeenSet = true;
    m_gameServers.emplace_back(std::forward<GameServersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates where to resume retrieving results on the next call to
   * this operation. If no token is returned, these results represent the end of the
   * list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListGameServersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListGameServersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<GameServer> m_gameServers;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_gameServersHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GameLift
}  // namespace Aws
