/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class BorderHighlighter
extends AbstractHighlighter {
    private Border paddingBorder;
    private boolean inner;
    private boolean compound;

    public BorderHighlighter() {
        this(null, null);
    }

    public BorderHighlighter(HighlightPredicate predicate) {
        this(predicate, null);
    }

    public BorderHighlighter(Border paddingBorder) {
        this(null, paddingBorder);
    }

    public BorderHighlighter(HighlightPredicate predicate, Border paddingBorder) {
        this(predicate, paddingBorder, true);
    }

    public BorderHighlighter(HighlightPredicate predicate, Border paddingBorder, boolean compound) {
        this(predicate, paddingBorder, compound, false);
    }

    public BorderHighlighter(HighlightPredicate predicate, Border paddingBorder, boolean compound, boolean inner) {
        super(predicate);
        this.paddingBorder = paddingBorder;
        this.compound = compound;
        this.inner = inner;
    }

    @Override
    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        ((JComponent)renderer).setBorder(this.compoundBorder(((JComponent)renderer).getBorder()));
        return renderer;
    }

    @Override
    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return this.getBorder() != null && component instanceof JComponent;
    }

    public void setCompound(boolean compound) {
        if (this.isCompound() == compound) {
            return;
        }
        this.compound = compound;
        this.fireStateChanged();
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setInner(boolean inner) {
        if (this.isInner() == inner) {
            return;
        }
        this.inner = inner;
        this.fireStateChanged();
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setBorder(Border padding) {
        if (this.areEqual(padding, this.getBorder())) {
            return;
        }
        this.paddingBorder = padding;
        this.fireStateChanged();
    }

    public Border getBorder() {
        return this.paddingBorder;
    }

    private Border compoundBorder(Border border) {
        if (this.compound && border != null) {
            if (this.inner) {
                return BorderFactory.createCompoundBorder(border, this.paddingBorder);
            }
            return BorderFactory.createCompoundBorder(this.paddingBorder, border);
        }
        return this.paddingBorder;
    }
}

