/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import ucar.nc2.constants.CDM;
import ucar.nc2.time.CalendarDateFormatter;

abstract class DoradeDescriptor {
    protected String descName;
    protected String expectedName;
    protected RandomAccessFile file;
    protected boolean littleEndianData;
    protected boolean verbose;
    protected static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    private static boolean defaultVerboseState = false;
    private static HashMap<String, Boolean> classVerboseStates = new HashMap();

    DoradeDescriptor() {
    }

    protected byte[] readDescriptor(RandomAccessFile file, boolean littleEndianData, String expectedName) throws DescriptorException {
        byte[] data;
        this.file = file;
        this.littleEndianData = littleEndianData;
        this.expectedName = expectedName;
        this.verbose = DoradeDescriptor.getDefaultVerboseState(expectedName);
        try {
            this.findNext(file);
            long startpos = file.getFilePointer();
            byte[] header = new byte[8];
            file.readFully(header);
            this.descName = new String(header, 0, 4, CDM.utf8Charset);
            int size = this.grabInt(header, 4);
            file.seek(startpos);
            data = new byte[size];
            file.readFully(data);
        }
        catch (IOException ex) {
            throw new DescriptorException(ex);
        }
        if (!this.descName.equals(expectedName)) {
            throw new DescriptorException("Got descriptor name '" + this.descName + "' when expecting name '" + expectedName + "'");
        }
        return data;
    }

    protected static void skipDescriptor(RandomAccessFile file, boolean littleEndianData) throws DescriptorException, IOException {
        try {
            file.readFully(new byte[4]);
            byte[] lenBytes = new byte[4];
            file.readFully(lenBytes);
            int descLen = DoradeDescriptor.grabInt(lenBytes, 0, littleEndianData);
            file.readFully(new byte[descLen - 8]);
        }
        catch (EOFException eofex) {
            return;
        }
        catch (Exception ex) {
            throw new DescriptorException(ex);
        }
    }

    protected static String peekName(RandomAccessFile file) throws DescriptorException {
        try {
            long filepos = file.getFilePointer();
            byte[] nameBytes = new byte[4];
            if (file.read(nameBytes) == -1) {
                return null;
            }
            file.seek(filepos);
            return new String(nameBytes, CDM.utf8Charset);
        }
        catch (IOException ex) {
            throw new DescriptorException(ex);
        }
    }

    public static boolean sweepfileIsLittleEndian(RandomAccessFile file) throws DescriptorException {
        int descLen;
        try {
            file.seek(0L);
            byte[] bytes = new byte[4];
            file.readFully(bytes);
            descLen = file.readInt();
            file.seek(0L);
        }
        catch (Exception ex) {
            throw new DescriptorException(ex);
        }
        return descLen < 0 || descLen > 0xFFFFFF;
    }

    protected short grabShort(byte[] bytes, int offset) {
        int ndx0 = offset + (this.littleEndianData ? 1 : 0);
        int ndx1 = offset + (this.littleEndianData ? 0 : 1);
        return (short)(bytes[ndx0] << 8 | bytes[ndx1] & 0xFF);
    }

    protected static int grabInt(byte[] bytes, int offset, boolean littleEndianData) {
        int ndx0 = offset + (littleEndianData ? 3 : 0);
        int ndx1 = offset + (littleEndianData ? 2 : 1);
        int ndx2 = offset + (littleEndianData ? 1 : 2);
        int ndx3 = offset + (littleEndianData ? 0 : 3);
        return bytes[ndx0] << 24 | (bytes[ndx1] & 0xFF) << 16 | (bytes[ndx2] & 0xFF) << 8 | bytes[ndx3] & 0xFF;
    }

    protected int grabInt(byte[] bytes, int offset) {
        return DoradeDescriptor.grabInt(bytes, offset, this.littleEndianData);
    }

    protected float grabFloat(byte[] bytes, int offset) throws DescriptorException {
        try {
            byte[] src;
            if (this.littleEndianData) {
                src = new byte[]{bytes[offset + 3], bytes[offset + 2], bytes[offset + 1], bytes[offset]};
                offset = 0;
            } else {
                src = bytes;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(src, offset, 4));
            return stream.readFloat();
        }
        catch (Exception ex) {
            throw new DescriptorException(ex);
        }
    }

    protected double grabDouble(byte[] bytes, int offset) throws DescriptorException {
        try {
            byte[] src;
            if (this.littleEndianData) {
                src = new byte[]{bytes[offset + 7], bytes[offset + 6], bytes[offset + 5], bytes[offset + 4], bytes[offset + 3], bytes[offset + 2], bytes[offset + 1], bytes[offset]};
                offset = 0;
            } else {
                src = bytes;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(src, offset, 8));
            return stream.readDouble();
        }
        catch (Exception ex) {
            throw new DescriptorException(ex);
        }
    }

    protected static long findNextWithName(String expectedName, RandomAccessFile file, boolean littleEndianData) throws DescriptorException, IOException {
        String descName;
        while ((descName = DoradeDescriptor.peekName(file)) != null) {
            if (descName.equals(expectedName)) {
                try {
                    return file.getFilePointer();
                }
                catch (IOException ex) {
                    throw new DescriptorException(ex);
                }
            }
            DoradeDescriptor.skipDescriptor(file, littleEndianData);
        }
        throw new DescriptorException("Expected " + expectedName + " descriptor not found!");
    }

    protected long findNext(RandomAccessFile file) throws DescriptorException, IOException {
        return DoradeDescriptor.findNextWithName(this.expectedName, file, this.littleEndianData);
    }

    public static String formatDate(Date date) {
        return CalendarDateFormatter.toDateTimeString(date);
    }

    public static boolean getDefaultVerboseState() {
        return defaultVerboseState;
    }

    public static void setDefaultVerboseState(boolean verbose) {
        defaultVerboseState = verbose;
        classVerboseStates.clear();
    }

    public static boolean getDefaultVerboseState(String descriptorName) {
        Boolean classVerboseState = classVerboseStates.get(descriptorName.toUpperCase());
        if (classVerboseState != null) {
            return classVerboseState;
        }
        return defaultVerboseState;
    }

    public static void setDefaultVerboseState(String descriptorName, boolean verbose) {
        classVerboseStates.put(descriptorName.toUpperCase(), verbose);
    }

    static class DescriptorException
    extends Exception {
        protected DescriptorException(String message) {
            super(message);
        }

        protected DescriptorException(Throwable cause) {
            super(cause);
        }
    }
}

