\name{GaborImageSource}
\alias{GaborImageSource}
\title{GaborImageSource}
\Rdversion{1.1}
\docType{class}
\description{
Generate an n-dimensional image of a Gabor filter.
GaborImageSource}
\details{
GaborImageSource generates an image of either the real (i.e. symmetric) or complex
(i.e. antisymmetric) part of the Gabor filter with the orientation
directed along the x-axis. The GaborKernelFunction is used to evaluate the contribution along the x-axis whereas a non-
normalized 1-D Gaussian envelope provides the contribution in each of
the remaining N dimensions. Orientation can be manipulated via the Transform classes of the toolkit.
The output image may be of any dimension.
This implementation was contributed as a paper to the Insight Journal https://www.insight-journal.org/browse/publication/150
See:
GaborSource for the procedural interface
itk::GaborImageSource for the Doxygen on the original ITK class.
GaborImageSource}
%C++ includes: sitkGaborImageSource.h
\section{Methods}{
\describe{
\item{Image Execute():}{
Execute the filter on the input image
}
\item{ GaborImageSource():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::vector< double > GetDirection() const:}{}
\item{double GetFrequency() const:}{
Set/Get the modulation frequency of the sine or cosine component.
}
\item{std::vector< double > GetMean() const:}{
Set/Get the mean in each direction.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOrigin() const:}{}
\item{PixelIDValueEnum GetOutputPixelType() const:}{}
\item{std::vector< double > GetSigma() const:}{
Set/Get the the standard deviation in each direction.
}
\item{std::vector< unsigned int > GetSize() const:}{}
\item{std::vector< double > GetSpacing() const:}{}
\item{Self SetDirection(std::vector< double > Direction):}{}
\item{Self SetFrequency(double Frequency):}{
Set/Get the modulation frequency of the sine or cosine component.
}
\item{Self SetMean(double value):}{
Set the values of the Mean vector all to value
}
\item{Self SetMean(std::vector< double > Mean):}{
Set/Get the mean in each direction.
}
\item{Self SetOrigin(std::vector< double > Origin):}{}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{}
\item{Self SetSigma(double value):}{
Set the values of the Sigma vector all to value
}
\item{Self SetSigma(std::vector< double > Sigma):}{
Set/Get the the standard deviation in each direction.
}
\item{Self SetSize(std::vector< unsigned int > Size):}{}
\item{Self SetSpacing(std::vector< double > Spacing):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GaborImageSource():}{
Destructor
}
}
}
