/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.ClassicGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;

public class ClassicGroupDescription {
    private final String groupId;
    private final String protocol;
    private final String protocolData;
    private final Collection<MemberDescription> members;
    private final ClassicGroupState state;
    private final Node coordinator;
    private final Set<AclOperation> authorizedOperations;

    public ClassicGroupDescription(String groupId, String protocol, String protocolData, Collection<MemberDescription> members, ClassicGroupState state, Node coordinator) {
        this(groupId, protocol, protocolData, members, state, coordinator, Set.of());
    }

    public ClassicGroupDescription(String groupId, String protocol, String protocolData, Collection<MemberDescription> members, ClassicGroupState state, Node coordinator, Set<AclOperation> authorizedOperations) {
        this.groupId = groupId == null ? "" : groupId;
        this.protocol = protocol;
        this.protocolData = protocolData == null ? "" : protocolData;
        this.members = members == null ? List.of() : List.copyOf(members);
        this.state = state;
        this.coordinator = coordinator;
        this.authorizedOperations = authorizedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassicGroupDescription that = (ClassicGroupDescription)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.protocolData, that.protocolData) && Objects.equals(this.members, that.members) && this.state == that.state && Objects.equals(this.coordinator, that.coordinator) && Objects.equals(this.authorizedOperations, that.authorizedOperations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.protocol, this.protocolData, this.members, this.state, this.coordinator, this.authorizedOperations});
    }

    public String groupId() {
        return this.groupId;
    }

    public String protocol() {
        return this.protocol;
    }

    public String protocolData() {
        return this.protocolData;
    }

    public boolean isSimpleConsumerGroup() {
        return this.protocol.isEmpty();
    }

    public Collection<MemberDescription> members() {
        return this.members;
    }

    public ClassicGroupState state() {
        return this.state;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", protocol='" + this.protocol + "', protocolData=" + this.protocolData + ", members=" + this.members.stream().map(MemberDescription::toString).collect(Collectors.joining(",")) + ", state=" + String.valueOf((Object)this.state) + ", coordinator=" + String.valueOf(this.coordinator) + ", authorizedOperations=" + String.valueOf(this.authorizedOperations) + ")";
    }
}

