/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.action.RestActions;

public class BroadcastResponse
extends ActionResponse
implements ToXContentObject {
    public static final DefaultShardOperationFailedException[] EMPTY = new DefaultShardOperationFailedException[0];
    private static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    private static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    private static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    private static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private int totalShards;
    private int successfulShards;
    private int failedShards;
    private DefaultShardOperationFailedException[] shardFailures = EMPTY;

    protected static <T extends BroadcastResponse> void declareBroadcastFields(ConstructingObjectParser<T, Void> PARSER) {
        ConstructingObjectParser shardsParser = new ConstructingObjectParser("_shards", true, arg -> new BroadcastResponse((Integer)arg[0], (Integer)arg[1], (Integer)arg[2], (List)arg[3]));
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), TOTAL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), SUCCESSFUL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), FAILED_FIELD);
        shardsParser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DefaultShardOperationFailedException.fromXContent((XContentParser)p), FAILURES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)shardsParser, _SHARDS_FIELD);
    }

    public BroadcastResponse() {
    }

    public BroadcastResponse(StreamInput in) throws IOException {
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        if (size > 0) {
            this.shardFailures = new DefaultShardOperationFailedException[size];
            for (int i = 0; i < size; ++i) {
                this.shardFailures[i] = DefaultShardOperationFailedException.readShardOperationFailed((StreamInput)in);
            }
        }
    }

    public BroadcastResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures == null ? EMPTY : shardFailures.toArray(new DefaultShardOperationFailedException[0]);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public RestStatus getStatus() {
        if (this.failedShards > 0) {
            return this.shardFailures[0].status();
        }
        return RestStatus.OK;
    }

    public DefaultShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.shardFailures.length);
        for (DefaultShardOperationFailedException exp : this.shardFailures) {
            exp.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        RestActions.buildBroadcastShardsHeader(builder, params, this);
        this.addCustomXContentFields(builder, params);
        builder.endObject();
        return builder;
    }

    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }
}

