/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Objects;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;

public abstract class ConnectionFactoryAdapterBase
implements ConnectionFactoryAdapter {
    static final String CLASS_NAME = ConnectionFactoryAdapterBase.class.getName();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private UniversalConnectionPool m_universalConnectionPool;

    protected ConnectionFactoryAdapterBase(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    protected ConnectionFactoryAdapterBase() {
        this(DiagnosticsCollectorImpl.getCommon());
    }

    @Override
    public abstract Object createConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void closeConnection(Object var1) throws UniversalConnectionPoolException;

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            void connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "createPooledConnection", "entering args ({0}, {1})", null, null, object, connectionRetrievalInfo);
            UniversalConnectionPoolBase connectionPool = (UniversalConnectionPoolBase)this.getUniversalConnectionPool();
            this.trace(Level.FINE, CLASS_NAME, "createPooledConnection", "pooled connection created", null, null, new Object[0]);
            UniversalPooledConnectionImpl universalPooledConnectionImpl = new UniversalPooledConnectionImpl(connectionPool, connection, (ConnectionRetrievalInfo)connectionRequestInfo);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "createPooledConnection", "returning {0}", null, null, universalPooledConnectionImpl);
            return universalPooledConnectionImpl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "createPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public UniversalConnectionPool getUniversalConnectionPool() {
        return this.m_universalConnectionPool;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setUniversalConnectionPool(UniversalConnectionPool universalConnectionPool) throws UniversalConnectionPoolException {
        try {
            void universalConnectionPool2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "setUniversalConnectionPool", "entering args ({0})", null, null, universalConnectionPool);
            if (universalConnectionPool2 == null) {
                UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(54);
                this.trace(Level.WARNING, CLASS_NAME, "setUniversalConnectionPool", "", null, e, new Object[0]);
                throw e;
            }
            this.m_universalConnectionPool = universalConnectionPool2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "setUniversalConnectionPool", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionFactoryAdapterBase", "setUniversalConnectionPool", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

