/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.chart.util.PublicCloneable;

public class CloneUtils {
    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException e) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static List<?> cloneList(List<?> source2) {
        Args.nullNotPermitted(source2, "source");
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : source2) {
            if (obj == null) {
                result.add(null);
                continue;
            }
            if (obj.getClass() == String.class) {
                result.add(obj);
                continue;
            }
            try {
                result.add(ObjectUtils.clone(obj));
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public static Map cloneMapValues(Map source2) {
        Args.nullNotPermitted(source2, "source");
        HashMap result = new HashMap();
        for (Object key : source2.keySet()) {
            Object value = source2.get(key);
            if (value != null) {
                try {
                    result.put(key, ObjectUtils.clone(value));
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            result.put(key, null);
        }
        return result;
    }
}

