/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.api;

import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.Path;
import org.keycloak.Config;
import org.keycloak.admin.api.AdminApi;
import org.keycloak.admin.api.realm.DefaultRealmsApi;
import org.keycloak.admin.api.realm.RealmsApi;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmsAdminResource;

public class DefaultAdminApi
implements AdminApi {
    private final KeycloakSession session;
    private final RealmsAdminResource realmsAdminResource;
    private final AdminAuth auth;

    public DefaultAdminApi(KeycloakSession session) {
        this.session = session;
        this.auth = AdminRoot.authenticateRealmAdminRequest((KeycloakSession)session);
        if (!this.auth.getRealm().getName().equals(Config.getAdminRealm()) || !this.auth.hasRealmRole("admin")) {
            throw new NotAuthorizedException((Object)"Wrong permissions", new Object[0]);
        }
        this.realmsAdminResource = new RealmsAdminResource(session, this.auth, new TokenManager());
    }

    @Override
    @Path(value="realms")
    public RealmsApi realms() {
        return new DefaultRealmsApi(this.session, this.realmsAdminResource);
    }
}

