/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public final class FxmlPresenceListener
implements BulkFileListener {
    private static final Key<ModificationTracker> KEY = Key.create((String)"fxml.presence.modification.tracker");
    private final SimpleModificationTracker myModificationTracker;

    public FxmlPresenceListener(@NotNull Project project) {
        if (project == null) {
            FxmlPresenceListener.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        project.putUserData(KEY, (Object)this.myModificationTracker);
    }

    static ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            FxmlPresenceListener.$$$reportNull$$$0(1);
        }
        return () -> {
            ModificationTracker tracker = (ModificationTracker)project.getUserData(KEY);
            return tracker != null ? tracker.getModificationCount() + 1L : 0L;
        };
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            FxmlPresenceListener.$$$reportNull$$$0(2);
        }
        for (VFileEvent vFileEvent : events) {
            this.checkEvent(vFileEvent);
        }
    }

    private void checkEvent(@NotNull VFileEvent event) {
        if (event == null) {
            FxmlPresenceListener.$$$reportNull$$$0(3);
        }
        if (event instanceof VFileContentChangeEvent) {
            return;
        }
        if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
            if ("name".equals(propertyChangeEvent.getPropertyName())) {
                String oldName = (String)propertyChangeEvent.getOldValue();
                String newName = (String)propertyChangeEvent.getNewValue();
                if (oldName != null && newName != null && oldName.endsWith(".fxml") != newName.endsWith(".fxml")) {
                    this.myModificationTracker.incModificationCount();
                }
            }
        } else {
            VirtualFile file = event.getFile();
            if (file != null && JavaFxFileTypeFactory.isFxml(file)) {
                this.myModificationTracker.incModificationCount();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/FxmlPresenceListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModificationTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

