/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J5\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u001a\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000 H\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "getName", "", "setName", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "name", "isCompanion", "", "getTextOffset", "", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "isObjectLiteral", "getObjectKeyword", "getIdentifyingElement", "getCompanionObjects", "", "psi-api"})
@SourceDebugExtension(value={"SMAP\nKtObjectDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtObjectDeclaration.kt\norg/jetbrains/kotlin/psi/KtObjectDeclaration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class KtObjectDeclaration
extends KtClassOrObject {
    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        super(stub, (IStubElementType<?, ?>)KtStubBasedElementTypes.OBJECT_DECLARATION);
    }

    private final KotlinObjectStub get_stub() {
        Object t2 = this.getGreenStub();
        return t2 instanceof KotlinObjectStub ? (KotlinObjectStub)t2 : null;
    }

    @Override
    @Nullable
    public String getName() {
        String string = super.getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (this.isCompanion() && !this.isTopLevel()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.getNameIdentifier() == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            PsiElement psiElement2 = psiFactory.createIdentifier(name2);
            PsiElement psiElement3 = this.getObjectKeyword();
            Intrinsics.checkNotNull((Object)psiElement3);
            PsiElement result2 = this.addAfter(psiElement2, psiElement3);
            PsiElement psiElement4 = psiFactory.createWhiteSpace();
            PsiElement psiElement5 = this.getObjectKeyword();
            Intrinsics.checkNotNull((Object)psiElement5);
            this.addAfter(psiElement4, psiElement5);
            PsiElement psiElement6 = result2;
            Intrinsics.checkNotNull((Object)psiElement6);
            psiElement = psiElement6;
        } else {
            PsiElement psiElement7 = super.setName(name2);
            Intrinsics.checkNotNull((Object)psiElement7);
            psiElement = psiElement7;
        }
        return psiElement;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        int n2;
        Object object = this.getNameIdentifier();
        if (object != null && (object = object.getTextRange()) != null) {
            n2 = ((TextRange)object).getStartOffset();
        } else {
            PsiElement psiElement = this.getObjectKeyword();
            Intrinsics.checkNotNull((Object)psiElement);
            n2 = psiElement.getTextRange().getStartOffset();
        }
        return n2;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitObjectDeclaration(this, data);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @Nullable
    public final PsiElement getObjectKeyword() {
        return this.findChildByType(KtTokens.OBJECT_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.getObjectKeyword();
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        return CollectionsKt.emptyList();
    }
}

