/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForDebugInfo;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB;\b\u0016\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForDebugInfo;", "preRenderedConstructors", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "renderBound", "bound", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderFlexibleTypeCompact", "lowerRendered", "upperRendered", "renderConstructor", "constructor", "nullabilityMarker", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeRendererForReadability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeRendererForReadability.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public class ConeTypeRendererForReadability
extends ConeTypeRendererForDebugInfo {
    @Nullable
    private final Map<TypeConstructorMarker, String> preRenderedConstructors;
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this.preRenderedConstructors = preRenderedConstructors;
        this.idRendererCreator = idRendererCreator;
    }

    public /* synthetic */ ConeTypeRendererForReadability(Map map, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            map = null;
        }
        this(map, (Function0<? extends ConeIdRenderer>)function0);
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder, @Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this(preRenderedConstructors, idRendererCreator);
        this.setBuilder(builder);
        this.setIdRenderer((ConeIdRenderer)idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder);
    }

    public /* synthetic */ ConeTypeRendererForReadability(StringBuilder stringBuilder, Map map, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            map = null;
        }
        this(stringBuilder, map, (Function0<? extends ConeIdRenderer>)function0);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeRigidType lower2 = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower2);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string2 = lower2 instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower2).getOriginal()), upperRendered) : null;
            string = string2;
            if (string2 == null) {
                string = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered = string;
        this.getBuilder().append(rendered);
    }

    private final String renderBound(ConeKotlinType bound) {
        ConeTypeRendererForReadability renderer = new ConeTypeRendererForReadability(new StringBuilder(), this.preRenderedConstructors, this.idRendererCreator);
        ConeTypeRenderer.render$default(renderer, bound, null, 2, null);
        String string = renderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        String array;
        String string;
        String mutableEntry;
        String simpleCollection;
        String string2;
        if (Intrinsics.areEqual((Object)lowerRendered, (Object)StringsKt.replace$default((String)upperRendered, (String)"?", (String)"", (boolean)false, (int)4, null))) {
            return StringsKt.replace$default((String)upperRendered, (String)"?", (String)"!", (boolean)false, (int)4, null);
        }
        if (StringsKt.endsWith$default((String)upperRendered, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lowerRendered + '?'), (Object)upperRendered)) {
            return lowerRendered + '!';
        }
        if (Intrinsics.areEqual((Object)('(' + lowerRendered + ")?"), (Object)upperRendered)) {
            return '(' + lowerRendered + ")!";
        }
        String it = string2 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string3 = StringsKt.startsWith$default((String)lowerRendered, (String)it, (boolean)false, (int)2, null) ? string2 : null;
        if (string3 == null) {
            string3 = "";
        }
        String kotlinCollectionsPrefix = string3;
        String mutablePrefix = "Mutable";
        String string4 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string4 != null) {
            return string4;
        }
        String string5 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string5 != null) {
            return string5;
        }
        String it2 = string = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl2 = false;
        String string6 = StringsKt.startsWith$default((String)lowerRendered, (String)it2, (boolean)false, (int)2, null) ? string : null;
        if (string6 == null) {
            string6 = "";
        }
        String kotlinPrefix = string6;
        String string7 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string7 != null) {
            return string7;
        }
        return null;
    }

    @Override
    public void renderConstructor(@NotNull TypeConstructorMarker constructor, @NotNull String nullabilityMarker) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)nullabilityMarker, (String)"nullabilityMarker");
        Map<TypeConstructorMarker, String> map = this.preRenderedConstructors;
        if (map != null && (map = map.get(constructor)) != null) {
            Map<TypeConstructorMarker, String> it = map;
            boolean bl = false;
            this.getBuilder().append(StringsKt.replace$default((String)((Object)it), (String)"^", (String)nullabilityMarker, (boolean)false, (int)4, null));
            return;
        }
        super.renderConstructor(constructor, nullabilityMarker);
    }
}

