/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.ComponentProvider;
import ghidra.app.context.RestrictedAddressSetContext;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.features.base.codecompare.panel.CodeComparisonActionContext;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.features.codecompare.decompile.TokenPair;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Duo;
import java.awt.Component;
import java.util.List;

public class DualDecompilerActionContext
extends CodeComparisonActionContext
implements RestrictedAddressSetContext {
    private DecompilerCodeComparisonView comparisonProvider = null;
    private TokenPair tokenPair;
    private boolean overrideReadOnly = false;

    public DualDecompilerActionContext(ComponentProvider provider, DecompilerCodeComparisonView comparisonProvider, Component source) {
        super(provider, (CodeComparisonView)comparisonProvider, source);
        this.comparisonProvider = comparisonProvider;
        this.tokenPair = this.computeTokenPair();
    }

    private TokenPair computeTokenPair() {
        DecompilerPanel focusedPanel = this.comparisonProvider.getActiveDisplay().getDecompilerPanel();
        ProgramLocation programLocation = focusedPanel.getCurrentLocation();
        if (!(programLocation instanceof DecompilerLocation)) {
            return null;
        }
        DecompilerLocation focusedLocation = (DecompilerLocation)programLocation;
        ClangToken focusedToken = focusedLocation.getToken();
        if (focusedToken == null) {
            return null;
        }
        List<TokenBin> tokenBin = this.comparisonProvider.getHighBins();
        if (tokenBin == null) {
            return null;
        }
        TokenBin containingBin = TokenBin.getBinContainingToken(tokenBin, focusedToken);
        if (containingBin == null) {
            return null;
        }
        TokenBin matchedBin = containingBin.getMatch();
        if (matchedBin == null) {
            return null;
        }
        for (ClangToken currentMatch : matchedBin) {
            if (!currentMatch.getClass().equals(focusedToken.getClass())) continue;
            return this.comparisonProvider.getActiveSide() == Duo.Side.LEFT ? new TokenPair(focusedToken, currentMatch) : new TokenPair(currentMatch, focusedToken);
        }
        return null;
    }

    public DecompilerCodeComparisonView getCodeComparisonView() {
        return this.comparisonProvider;
    }

    public HighFunction getHighFunction(Duo.Side side) {
        return this.comparisonProvider.getDecompilerPanel(side).getController().getHighFunction();
    }

    public TokenPair getTokenPair() {
        return this.tokenPair;
    }

    void setOverrideReadOnly(boolean overrideReadOnly) {
        this.overrideReadOnly = overrideReadOnly;
    }

    public boolean isActiveProgramReadOnly() {
        if (this.overrideReadOnly) {
            return false;
        }
        Program activeProgram = this.comparisonProvider.getProgram(this.comparisonProvider.getActiveSide());
        if (activeProgram == null) {
            return true;
        }
        return activeProgram.getDomainFile().isReadOnly();
    }
}

